/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmSourceExpand.h
 *
 * Transmit a tarball from a client to the server.  Get status
 * back from tar executed on the server.
 *****************************************************************/

#ifndef __nmSourceExpand_h_
#define __nmSourceExpand_h_

#include <fstream>
#include "netmessage.h"

class nmSourceExpand : public netmessage
{
 public:
    nmSourceExpand(const char* _filepath,
                   const char* _tarname,
                   transport * connection,
                   unsigned long sessID,
                   unsigned long commdID);
    nmSourceExpand(transport* connection, unsigned long sess, unsigned long cmd);
    ~nmSourceExpand() { }
    int activate();
    int getProcessStatus() { return (processStatus); }

    // if these are called these prior to calling unfill() the return values
    // will indicate failure.
    void prepareToSend();
    char* getFileName();
    int getElapsedTime();
    int getNumberOfFiles();
    int getElapsedSeconds();
    int getElapsedUSeconds();
    int send(transport *sock, unsigned long opcode);

private:
    // private members
    char* filePath;             // client side path to tarball
    char* filename;             // exact file name of tarball
    char* pkgname;              // name of project
    char* filePathStr;          // c string for file to send
    char* streamFile;           // contents of stdout/stderr from tar expand
    int tarballFD;              // handle to the tarball
    int elapsedTime;            // number of seconds to execute
    int numberOfFiles;          // number of files expanded; from server
    int elapsedsec;             // elapsed time in seconds
    int elapsedusec;            // elapsed time additional microseconds
    int processStatus;          // status from olyexec

    // illegal to use default constructor  --  unimplemented
    nmSourceExpand();
};
#endif //  __nmSourceExpand_h_
