/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmSourceConfig.h
 *
 * Send the request to build the package on the server host.  Of
 * course this requires that the host have the necessary tools
 * (compiler etc) to build the package.
 *****************************************************************/

#ifndef __nmSourceConfig_h_
#define __nmSourceConfig_h_

#include "netmessage.h"

class nmSourceConfig : netmessage
{
public:
    nmSourceConfig(const char* name, transport* connection, unsigned int sessionID, unsigned int commandID);
    nmSourceConfig(transport* connection, unsigned long sessID, unsigned long commID);
    ~nmSourceConfig();
    void prepareToSend();
    int activate();

    // data access methodss
    char* getFileName();
    char* getPkgName();
    char* getStreamFile();
    int getProcessStatus();
    int getSeconds();
    int getUSeconds();
    void setOptions(const char *options);

private:
    nmSourceConfig();           // unused default constructor

    // private data
    char* filename;             // name of the original file
    char* options;              // options to configure
    char* pkgname;              // tar package name
    char* streamFile;           // stream of data from the process
    int processStatus;
    int seconds;
    int useconds;
};

#endif
