/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmSourceBuild.h
 *
 * Send the request to build the package on the server host.  Of
 * course this requires that the host have the necessary tools
 * (compiler etc) to build the package.
 *****************************************************************/

#ifndef __nmSourceBuild_h_
#define __nmSourceBuild_h_

#include "netmessage.h"

class nmSourceBuild : public netmessage
{
public:
    nmSourceBuild(const char* name, transport* socket, unsigned int sessionID, unsigned int commandID);
    ~nmSourceBuild();
    void prepareToSend();
    int activate();

    // data access methods
    char* getFileName();
    char* getPkgName();
    char* getStreamFile();
    int getProcessStatus();
    int getSeconds();
    int getUSeconds();
    void setOptions(const char *options);

private:
    nmSourceBuild();            // hidden

    // data
    char* filename;
    char* pkgname;
    char* options;              // options for make
    char* streamFile;           // results from process output
    int processStatus;
    int seconds;                // processing elapsed time
    int useconds;               // remainder in microseconds
};

#endif __nmSourceBuild_h_
