/*
 * nmKexInit.cc: get primes for Diffie Hellman key exchange
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __nmKexInit_h_
#define __nmKexInit_h_

#include "olympus.h"
#include "netmessage.h"

class nmKexInit: public netmessage
{
    public:
        nmKexInit(transport* connection, unsigned long sessionID, unsigned long commandID, int n);
        nmKexInit(transport* connection, unsigned long sessionID, unsigned long commandID);
        ~nmKexInit(void);

        int activate(void);
        void prepareToSend(void);

    private:
        unsigned char* p;
        unsigned char* g;
        unsigned char* f;
        int nbits_p;
        int nbits_g;
        int nbits_f;
};

#endif /* __nmKexInit_h_ */
