/*********************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmFetchConfig.h
 *
 * use the netmessage class to transmit the file back to the client.
 *********************************************************************/

/*  activate needs to be rewritten as there is no longer a tempFile object available
    instead, it needs to handle the file all on its own.
    
    Aaron 5-1-2000
*/    

#ifndef NMFETCHCONFIG_H
#define NMFETCHCONFIG_H

#include <stdlib.h>
#include <fstream>

#include "netmessage.h"

class nmFetchConfig : public netmessage
{
  public:
    
    nmFetchConfig(char* _module,
                  char* _file,
                  transport *connection,
                  unsigned long sessionID,
                  unsigned long commandID);

    ~nmFetchConfig();

    // acess to the config data
    char* configData() { return fileReceived; }

    // implement virtual netmessage methods
    int activate();
    void prepareToSend();

  private:
    char* fileReceived;
    char* module;
    char* file;
};

#endif
