/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   moduleList.cc 
*
*   a doubly linked list of modules for hostObjs
*   constructors and destructors
*
*****************************************************************************/

#include "olympus.h"
#include "moduleList.h"
#include "module.h"

//#define DEBUGMODULELIST

moduleList::moduleList(module *newModule, moduleList *newNextModule = NULL, moduleList *newPrevModule = NULL)
{
    #ifdef DEBUG_MODULELIST
        debug("adding module with nextMod = %i and prevMod = %i", newNextModule, newPrevModule);
    #endif	

    thisModule = newModule;
    nextModule = newNextModule;
    prevModule = newPrevModule;
    if (newPrevModule)
    {	
        newPrevModule->setNextModule(this);
    }
    if (newNextModule)
    {
        newNextModule->setPrevModule(this);
    }

    open = false;
}

moduleList::~moduleList()
{
    #ifdef DEBUG_MODULELIST
        debug("deleting a module here, folks");
    #endif	

    if (open)
    {
        #ifdef DEBUG_MODULELIST
            debug("open, so closing first");
        #endif

        client->deleteModule(mid);
    }
    if (prevModule != NULL)
    {
        #ifdef DEBUG_MODULELIST
            debug("pointer backwards, reseting");
        #endif

        prevModule->setNextModule(nextModule);
    }
    if (nextModule != NULL)
    {
        #ifdef DEBUG_MODULELIST
            debug("pointer forwards, reseting");
        #endif

        nextModule->setPrevModule(prevModule);
    }
}

QString* moduleList::getModuleName() { return thisModule->getName(); }