/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   module.cc 
*   
*   a reference to a module .so that can be later loaded dynamically
*
*****************************************************************************/

#include "module.h"
#include "icons.h"

#include <qpixmap.h>

//#define DEBUG_MODULE
//#define DEBUG_MODULE_2

module::module(QString *newFileName, QString *newClassname, QString *newName, QString *newDesc, QString *groupName, QString *newCredits = NULL, QString *newVersion, QPixmap newIconSmall = NULL, QPixmap newIconLarge = NULL, QPixmap newLogo = NULL)
{
    #ifdef DEBUG_MODULE
        debug("module::module() -> start of constructor");
    #endif

    filename = new QString(*newFileName);
    classname = new QString(*newClassname);
    name = new QString(*newName);
    group = new QString(*groupName);
    description = new QString(*newDesc);
    credits = new QString(*newCredits);
    version = new QString(*newVersion);

    // setup the small icons to be what the module provides or else look
    // for icons by its name, or else just use the default icons.
    if (! newIconSmall.isNull())
    {
        #ifdef DEBUG_MODULE_2
            debug("     module >> going in for a small icon");
        #endif

        iconSmall = new QPixmap(newIconSmall);
    }
    else
    {
        // search here for icon by newName
        // or else use the default
        #ifdef DEBUG_MODULE_2
            debug("     module >> going in for the default small icon");
        #endif

        iconSmall = icon_small->find("plugin-default"); 
    }
  
    // setup the large icons to be what the module provides or else look
    // for icons by its name, or else just use the default icons.
    if (! newIconLarge.isNull())
    {
        iconLarge = new QPixmap(newIconLarge);
    }
    else
    {
        // search here for icon by newName
        // or else use the default
        iconLarge = icon_large->find("plugin-default"); 
    }

    if (! newLogo.isNull())
    {
        logo = new QPixmap(newLogo);
    }
    else
    {
        // search here for icon by newName
        // or else use the default
        logo = NULL;    
    }

    #ifdef DEBUG_MODULE
        debug("module::module() -> end of constructor");
    #endif

}

module::module(char *newFileName, char *newClassname, char *newName, char *newDesc, char *groupName, char *newCredits = NULL, char *newVersion, QPixmap newIconSmall = NULL, QPixmap newIconLarge = NULL, QPixmap newLogo = NULL)
{
    #ifdef DEBUG_MODULE
        debug("\nmodule::module() -> start of char* constructor");
    #endif

    filename = new QString(newFileName);
    classname = new QString(newClassname);
    name = new QString(newName);
    group = new QString(groupName);
    description = new QString(newDesc);
    credits = new QString(newCredits);
    version = new QString(newVersion);

    // setup the small icons to be what the module provides or else look
    // for icons by its name, or else just use the default icons.
    if (! newIconSmall.isNull())
    {
        #ifdef DEBUG_MODULE_2
            debug("     module >> going in for a small icon");
        #endif

        iconSmall = new QPixmap(newIconSmall);
    }
    else
    {
        // search here for icon by newName
        // or else use the default

        #ifdef DEBUG_MODULE_2
            debug("     module >> going in for the default small icon");
        #endif

        iconSmall = icon_small->find("plugin-default"); 
    }

    // setup the large icons to be what the module provides or else look
    // for icons by its name, or else just use the default icons.
    if (! newIconLarge.isNull())
    {
        iconLarge = new QPixmap(newIconLarge);
    }
    else
    {
        // search here for icon by newName
        // or else use the default

        iconLarge = icon_large->find("plugin-default"); 
    }

    if (! newLogo.isNull())
    {
        logo = new QPixmap(newLogo);
    }
    else
    {
        // search here for icon by newName
        // or else use the default

        logo = NULL;    
    }
 
    #ifdef DEBUG_MODULE
        debug("module::module() -> end of char* constructor\n");
    #endif
}
    
module::~module()
{
    #ifdef DEBUG_MODULE
        debug("module::~module() -> start of deconstructor");   
    #endif

    delete filename;
    delete name;
    delete group;
    delete description;
    delete credits;
    delete classname;
    delete version;
    delete iconSmall;
    delete iconLarge;
    delete logo;

    #ifdef DEBUG_MODULE
        debug("module::~module() -> end of deconstructor"); 
    #endif
}