/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   prefsModuleDirectorySelect.cc
*
*   Description:
*   Creates a file dialog to choose the directory of the location of
*   the plugins
*
*****************************************************************************/

#include "olympus.h"
#include "mainWindow.h"

#include <qfiledialog.h>

void mainWindow::prefsModuleDirectorySelect()
{
    #ifdef DEBUG
        debug("mainWindow::prefsModuleDirectorySelect() -> Start of function");
    #endif

    QFileDialog fd( QString::null, "", 0, 0, TRUE );
    fd.setMode(QFileDialog::Directory);
    fd.setCaption("Modules directory");
    fd.setSelection(client->prefs->find("modulePath")->data());

    if ( fd.exec() == QDialog::Accepted )
    {
        moduleLineEdit->setText(fd.selectedFile());
    }

    #ifdef DEBUG
        debug("mainWindow::prefsModuleDirectorySelect() -> End of function");
    #endif
}
