/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   prefsApplyButtonPressed.cc
*
*   Description:
*
*****************************************************************************/

#include "olympus.h"
#include "mainWindow.h"
#include "moduleList.h"
#include "pathValidator.h"

//#define DEBUG_PREFERENCES             // the Preferences default debug statement.
//#define DEBUG_PREFERENCES_CHECK       // General check to see it's everything is working.
//#define DEBUG_PREFERENCES_CHECK_2     // dumps all the variables...

#include <qlineedit.h>
#include <qlistview.h>

void mainWindow::prefsApplyButtonPressed()
{
    #ifdef DEBUG_PREFERENCES
        debug("mainWindow::prefsApplyButtonPressed() -> Start of function");
    #endif

    // Here we but in all the defaults for the host into the QDict.

    //propBoxSavePassword
    /* Broken... shoud fix
    if (client->prefs->find("defaultWeSavePassword") != NULL)
    {
        if (propBoxSavePassword->isChecked())
        {
            client->prefs->replace("defaultWeSavePassword", (const QString *)"TRUE");
        }
        else
        {
            client->prefs->replace("defaultWeSavePassword", (const QString *)"FALSE");
        }
    }               
    else
    {
        if (propBoxSavePassword->isChecked())
        {
            client->prefs->insert("defaultWeSavePassword", (const QString *)"TRUE");
        }
        else
        {
            client->prefs->insert("defaultWeSavePassword", (const QString *)"FALSE");
        }
    }
    */

    //propBoxCommonName
    #ifdef DEBUG_PREFERENCES_CHECK_2
        debug(propBoxCommonName->text());
    #endif
    if (client->prefs->find("defaultCommonName") != NULL)
    {
        client->prefs->replace("defaultCommonName", new QString(propBoxCommonName->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultCommonName found.");
        #endif
    }               
    else
    {
        client->prefs->insert("defaultCommonName", new QString(propBoxCommonName->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultCommonName wasn't found. now adding.");
        #endif
    }

    //propBoxHostname
    #ifdef DEBUG_PREFERENCES_CHECK_2
        debug(propBoxHostname->text());
    #endif
    if (client->prefs->find("defaultHostname") != NULL)
    {
        client->prefs->replace("defaultHostname", new QString(propBoxHostname->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultHostname found.");
        #endif
    }               
    else
    {
        client->prefs->insert("defaultHostname", new QString(propBoxHostname->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultHostname wasn't found. now adding.");
        #endif
    }

    //propBoxPort
    #ifdef DEBUG_PREFERENCES_CHECK_2
        debug(propBoxPort->text());
    #endif
    if (client->prefs->find("defaultPort") != NULL)
    {
        client->prefs->replace("defaultPort", new QString(propBoxPort->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultPort found.");
        #endif
    }               
    else
    {
        client->prefs->insert("defaultPort", new QString(propBoxPort->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultPort wasn't found. now adding.");
        #endif
    }

    //propBoxUsername
    #ifdef DEBUG_PREFERENCES_CHECK_2
        debug(propBoxUsername->text());
    #endif
    if (client->prefs->find("defaultUsername") != NULL)
    {
        client->prefs->replace("defaultUsername", new QString(propBoxUsername->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultUsername found.");
        #endif
    }               
    else
    {
        client->prefs->insert("defaultUsername", new QString(propBoxUsername->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultUsername wasn't found. now adding.");
        #endif
    }

    //propBoxPassword
    #ifdef DEBUG_PREFERENCES_CHECK_2
        debug(propBoxPassword->text());
    #endif
    if (client->prefs->find("defaultPassword") != NULL)
    {
        client->prefs->replace("defaultPassword", new QString(propBoxPassword->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultPassword found.");
        #endif
    }               
    else
    {
        client->prefs->insert("defaultPassword", new QString(propBoxPassword->text()));
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("defaultPassword wasn't found. now adding.");
        #endif
    }

    // other... Plugins/Modules
    //moduleLineEdit
    #ifdef DEBUG_PREFERENCES_CHECK_2
        debug(moduleLineEdit->text());
    #endif

    // do not delete newModPath, it is needed by the client prefs
    QString* newModPath = new QString(moduleLineEdit->text());
    pathValidator validate(0);
    validate.fixup(*newModPath);
                                 
    if (client->prefs->find("modulePath") != NULL)
    {
       if (*client->prefs->find("modulePath") != *newModPath)
       {
           client->prefs->replace("modulePath", newModPath);
           client->loadModules();
       }
       else { client->prefs->replace("modulePath", newModPath); }
    }
    else
    {
        client->prefs->insert("modulePath", new QString(moduleLineEdit->text()));
        client->loadModules();
    }

    // take care of the module list and any open modules
    if (client->defaultModules != NULL)
    {
        moduleList *thisMod = client->defaultModules;
        // go to the end of the list
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("going to the end of the list in defaultModules.");
        #endif
        while (thisMod->getNextModule())
        {
            thisMod = thisMod->getNextModule();
        }
        // go through the list backwards one by one to the end and
        // make sure not to delete the mod_admin
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("clearing the defaultModules");
        #endif

        /*  make sure we don't have a single item list, 
            e.g. that the last module (thisMod) isn't the same as the first */
        if (thisMod != client->defaultModules) 
        {   
            // go deletion happy up to the first item
            while (thisMod->getPrevModule()->getPrevModule() != NULL)
            {
                thisMod = thisMod->getPrevModule();
                delete thisMod->getNextModule();
            }
            delete thisMod;
        }

        //
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("\n------- Checking the linked lists -------");
            moduleList *w = client->defaultModules;
            while (w)
            {
                debug(": %s", w->getModuleName()->data());
                debug("-----------------------------------------");
                w = w->getNextModule();
            }
        #endif
        //

        // da... dump it baby.
        #ifdef DEBUG_PREFERENCES_CHECK
            debug("adding defaultModulesList checked items to client->defaultModules");
        #endif

        moduleList *tempModule = client->defaultModules;
        module *newModules;
        QListViewItemIterator it (defaultModulesList);
        while(it.current())
        {
            if (it.current()->depth() < 1 || it.current()->text(0) == "Olympus Admin")
            {
                #ifdef DEBUG_PREFERENCES_CHECK
                    debug("it's expandable... ==> %s", it.current()->text(0).data());
                #endif
            }
            else if (((QCheckListItem *)it.current())->isOn())
            {
                #ifdef DEBUG_PREFERENCES_CHECK
                    debug("\t>> it's checked! -> %s", it.current()->text(0).data());
                #endif

                if ((newModules = client->modules->find(it.current()->text(0).data())) > 0)
                {
                    new moduleList(newModules, NULL, tempModule);
                    tempModule = tempModule->getNextModule();

                    #ifdef DEBUG_PREFERENCES_CHECK
                        debug("\t>> Found module: %s", newModules->getName()->data());
                    #endif
                }
            }
            else
            {
                #ifdef DEBUG_PREFERENCES_CHECK
                    debug("nope... no good. ==> %s", it.current()->text(0).data());
                #endif
            }
            ++it;
        }
    }

    client->writeDefaultModulesFile();
    
    #ifdef DEBUG_PREFERENCES_CHECK
        debug("\n------- Checking the linked lists -------");
        moduleList *w = client->defaultModules;
        while (w)
        {
            debug(": %s", w->getModuleName()->data());
            debug("-----------------------------------------");
            w = w->getNextModule();
        }
    #endif

    #ifdef DEBUG_PREFERENCES
        debug("mainWindow::prefsApplyButtonPressed() -> End of function.. ");
    #endif
}
