/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    preferences.cc
*
*    Description:
*    The Preferences dialog.
*
*****************************************************************************/

#include "olympus.h"
#include "mainWindow.h"
#include "module.h"
#include "moduleList.h"
#include "pathValidator.h"

#include "regexx.hh"
using namespace regexx;

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qtabdialog.h>

//#define DEBUG_PREFERENCES

void mainWindow::preferences()
{
    #ifdef DEBUG
        debug("mainWindow::preferences() -> start of function");
    #endif

    prefs = new QTabDialog(this, "Preferences...");

    // pageZero
    QWidget *pageZero = new QWidget(0,"pageZero");
    QGridLayout *gridZero = new QGridLayout(pageZero, 10, 9);
    
    QLabel *userLabel = new QLabel(pageZero);
    userLabel->setText("Username:");
    QLabel *passLabel = new QLabel(pageZero);
    passLabel->setText("Password:");
    QLabel *loginLabel = new QLabel(pageZero);
    loginLabel->setText("Login Information:");
    loginLabel->setMinimumSize(userLabel->sizeHint().width() * 3, loginLabel->sizeHint().height());
    
    client->loginUsername = new QLineEdit(*client->username, pageZero);
    client->loginPassword = new QLineEdit(*client->password, pageZero);
    client->loginPassword->setEchoMode(QLineEdit::Password);

    QLabel *cryptoLabel = new QLabel(pageZero);
    cryptoLabel->setText("Encryption:");
    
    QListBox *cryptoListBox = new QListBox(pageZero);
    QPushButton *pushButtonUp = new QPushButton("Up", pageZero);
    QPushButton *pushButtonDown = new QPushButton("Down", pageZero);

    // Ok... lets put them in the grid...
    gridZero->addColSpacing(0, 10);
    gridZero->addColSpacing(1,loginLabel->sizeHint().width() / 3);
    gridZero->addColSpacing(3,loginLabel->sizeHint().width() / 3 * 2);
    gridZero->addColSpacing(2, 10);
    gridZero->addColSpacing(4, 20);
    gridZero->addColSpacing(6, 10);
    gridZero->addColSpacing(7, cryptoLabel->sizeHint().width());
    gridZero->addColSpacing(9,10);

    gridZero->addRowSpacing(0, 10);
    gridZero->addRowSpacing(2, cryptoLabel->sizeHint().height());
    gridZero->addRowSpacing(3, 10);
    gridZero->addRowSpacing(9,10);
    
    gridZero->addMultiCellWidget(loginLabel, 2, 2, 1, 3);
    gridZero->addMultiCellWidget(cryptoLabel, 2, 2, 5, 7);
    
    gridZero->addWidget(userLabel, 4, 1);
    gridZero->addWidget(client->loginUsername, 4, 3);
    
    gridZero->addMultiCellWidget(cryptoListBox, 4, 7, 5, 5);
    
    gridZero->addWidget(passLabel, 5, 1);
    gridZero->addWidget(client->loginPassword, 5, 3);
    
    gridZero->addWidget(pushButtonUp, 5, 7);
    gridZero->addWidget(pushButtonDown, 6, 7);
        
    // page one...
    QWidget *propertyPage = new QWidget(0,"property page");
    
    QLabel *commonNameLabel = new QLabel(propertyPage);
    commonNameLabel->setText("Default New Host Name");
    propBoxCommonName = new QLineEdit(propertyPage,"newCommonName");
    propBoxCommonName->setText(*client->prefs->find("defaultCommonName"));
    
    QLabel *hostnameLabel = new QLabel(propertyPage);
    hostnameLabel->setText("Default Hostname or IP Address");
    propBoxHostname = new QLineEdit(propertyPage,"newHostname");
    propBoxHostname->setText(*client->prefs->find("defaultHostName"));
    
    QLabel *portLabel = new QLabel(propertyPage);
    portLabel->setText("Default Port");
    propBoxPort = new QLineEdit(propertyPage,"newPortName");
    propBoxPort->setText(*client->prefs->find("defaultPort"));
    
    QLabel *usernameLabel = new QLabel(propertyPage);
    usernameLabel->setText("Default Username");
    propBoxUsername = new QLineEdit(propertyPage,"username");
    propBoxUsername->setText("admin");
    
    QLabel *passwordLabel = new QLabel(propertyPage);
    passwordLabel->setText("Default Password");
    propBoxPassword = new QLineEdit(propertyPage,"password");
    propBoxPassword->setText("password");
    propBoxPassword->setEchoMode(QLineEdit::Password);
    
    propBoxSavePassword = new QCheckBox("Save Passwords By Default",propertyPage,"passwordCheck");
    
    
    if (Regexx(client->prefs->find("defaultWeSavePassword")->data(), "TRUE"))
    {
        propBoxSavePassword->setChecked(true);
    }
    
    QGridLayout *propertyGrid = new QGridLayout(propertyPage,0,0);
    propertyGrid->addColSpacing(0,10);
    propertyGrid->addColSpacing(1,300);
    propertyGrid->addColSpacing(2,10);
    propertyGrid->addColSpacing(3,100);
    propertyGrid->addColSpacing(4,10);
    propertyGrid->addRowSpacing(0,10);
    propertyGrid->addWidget(commonNameLabel,1,1);
    propertyGrid->addWidget(propBoxCommonName, 2, 1);
    propertyGrid->addRowSpacing(3,10);
    propertyGrid->addWidget(hostnameLabel,4,1);
    propertyGrid->addWidget(propBoxHostname, 5, 1);
    propertyGrid->addWidget(portLabel,4,3);
    propertyGrid->addWidget(propBoxPort,5,3);
    propertyGrid->addRowSpacing(6,10);
    propertyGrid->addWidget(usernameLabel,7,1);
    propertyGrid->addWidget(propBoxUsername,8,1);
    propertyGrid->addRowSpacing(9,10);
    propertyGrid->addWidget(passwordLabel,10,1);
    propertyGrid->addWidget(propBoxPassword,11,1);
    propertyGrid->addWidget(propBoxSavePassword,12,1);
    propertyGrid->addRowSpacing(13,10);
    
    propertyGrid->setColStretch(5, 20);
    propertyGrid->setRowStretch(12, 20);


    // pageTwo
    QWidget *pageTwo = new QWidget(this);
    QGridLayout *gridTwo = new QGridLayout(pageTwo, 7, 4);

    QLabel *moduleLabel = new QLabel(pageTwo);  
    moduleLabel->setText("Plugins Directory:");
    moduleLineEdit = new QLineEdit(client->prefs->find("modulePath")->data(), pageTwo);
    
    QPushButton *modulePushButton = new QPushButton("...", pageTwo);
    QPushButton *loadPluginsButton = new QPushButton("Reload Plugins", pageTwo); 
    QLabel *pluginsLabel = new QLabel(pageTwo);
    pluginsLabel->setText("Default Plugins Applied To All New Hosts:");

    defaultModulesList = new QListView(pageTwo);
    defaultModulesList->setPalette(*client->listPalette);
    defaultModulesList->addColumn("Plugin");
    defaultModulesList->addColumn("Description");
    
    /// set the colours on the tree so it looks all purty...
    defaultModulesList->setRootIsDecorated( TRUE );
    createModuleList(defaultModulesList);

    gridTwo->addColSpacing(0, 10);
    gridTwo->addColSpacing(2, 10);
    gridTwo->addColSpacing(4, 10);

    gridTwo->addRowSpacing(0, 10);
    gridTwo->addWidget(moduleLabel, 1, 1);
    gridTwo->addWidget(moduleLineEdit, 2, 1);
    gridTwo->addWidget(modulePushButton, 2, 3);
    gridTwo->addRowSpacing(3, 5);
    gridTwo->addMultiCellWidget(loadPluginsButton, 4, 4, 1, 3);
    gridTwo->addRowSpacing(5, 10);

    gridTwo->addWidget(pluginsLabel, 6, 1);
    gridTwo->addRowSpacing(7, 5);
    gridTwo->addMultiCellWidget(defaultModulesList, 8, 8, 1, 3);

    gridTwo->addRowSpacing(9, 10);


    // lets but all the tabs into the TabDialaog ;)
    prefs->addTab(pageZero, "General");
    prefs->addTab(propertyPage,"New Hosts");
    prefs->addTab(pageTwo, "Plugins");

    // Pick and choose... shouldn't really show at all :p
    prefs->setOKButton();
    prefs->setApplyButton();
    prefs->setCancelButton();
    
    QObject::connect(modulePushButton, SIGNAL(clicked()),
                     this, SLOT(prefsModuleDirectorySelect()));
    
    QObject::connect(prefs, SIGNAL(applyButtonPressed()),
                     this, SLOT(prefsApplyButtonPressed()));
    QObject::connect(prefs, SIGNAL(applyButtonPressed()),
                     client, SLOT(setPasswordNoDelete()));
    
    QObject::connect(pushButtonUp, SIGNAL(clicked()),
                     this, SLOT(notimplemented()));
    QObject::connect(pushButtonDown, SIGNAL(clicked()),
                     this, SLOT(notimplemented()));
    
    QObject::connect(loadPluginsButton, SIGNAL(clicked()),
                     this, SLOT(prefsLoadPlugins()));
    
    prefs->setFixedSize(pageTwo->minimumSizeHint());
    prefs->setCaption("Olympus Client Preferences");
    prefs->show();

    #ifdef DEBUG
        debug("mainWindow::preferences() -> end of function");
    #endif
}

void mainWindow::prefsLoadPlugins()
{
    // do not delete newModPath, it is needed by the client prefs
    QString* newModPath = new QString(moduleLineEdit->text());
    pathValidator validate(0);
    validate.fixup(*newModPath);
                                 
    if (client->prefs->find("modulePath") != NULL)
    {
       client->prefs->replace("modulePath", newModPath);
    }
    else
    {
        client->prefs->insert("modulePath", new QString(moduleLineEdit->text()));
    }

    client->loadModules();
    defaultModulesList->clear();
    createModuleList(defaultModulesList);
}

void mainWindow::createModuleList(QListView* listview)
{
    QDictIterator<module> it(*client->modules);
    QListViewItem *thisNewGroup;
    QCheckListItem *thisNewItem;
    bool tempBool;
                    
    thisNewGroup = new QListViewItem(listview, "Olympus");
    thisNewGroup->setOpen(true);
    thisNewGroup->setExpandable(true);
    
    if (client->modules->find("Olympus Admin"))
    {
        thisNewGroup = new QListViewItem(thisNewGroup, "Olympus Admin");
        thisNewGroup->setText(1,*client->modules->find("Olympus Admin")->getDescription());
    }

    for ( ; it.current(); ++it )
    {
        if (*it.current()->getName() == "Olympus Admin") { continue; }

        tempBool = false;
        QListViewItem *groupToUse = new QListViewItem(listview);

        // if we have groups in the list (there are children, duh!)
        if (listview->firstChild())
        {
            delete groupToUse;
            groupToUse = listview->firstChild();

            // loop through the groups one by one and compare.          
            while (groupToUse && ! tempBool)
            {
                if (groupToUse->text(0) == *it.current()->getGroup())
                {
                    tempBool = TRUE;
                    break;
                }
                groupToUse = groupToUse->nextSibling();
            }
        }
        else { delete groupToUse; }

        // if there is a group, we don't need to make one
        if (tempBool)
        {
            thisNewItem = new QCheckListItem(groupToUse, it.current()->getName()->data(), QCheckListItem::CheckBox);
        }
        else // but there isn't in this case, so we make a new group in the list.
        {
            thisNewGroup = new QListViewItem(listview, it.current()->getGroup()->data());
            thisNewGroup->setOpen( TRUE );
            thisNewGroup->setExpandable( TRUE );
            thisNewItem = new QCheckListItem(thisNewGroup , it.current()->getName()->data(), QCheckListItem::CheckBox);
        }
        
        // set the second column of text to the description of the module
        thisNewItem->setText(1,*it.current()->getDescription());
        
        moduleList *thisModule = client->defaultModules;            

        while (thisModule)
        {
            // Is it a default Modules?
            if (Regexx(thisModule->getModule()->getName()->data(), it.current()->getName()->data()))
            {
                thisNewItem->setOn(true);
            }

            thisModule = thisModule->getNextModule();
        }
    }
}
