/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainWindow.cc
*
*    Description:
*    the main object for the application... QMainWindow with Toolbars
*    and Status bars and so forth and the main windows which is a splitter
*    with a QListView and QListBox as the main widgets...(if that makes any
*    sense ;)
*    gets called from main.cc
*
*****************************************************************************/

#include "olympus.h"
#include "mainWindow.h"
#include "groupObj.h"
#include "hostItem.h"
#include "hostObj.h"
#include "mainListBox.h"
#include "mainListView.h"

#include <qapplication.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qstatusbar.h>
#include <qvaluelist.h>

mainWindow::mainWindow()
{
    #ifdef DEBUG
        debug("mainWindow::mainWindow() -> start of constructor");
    #endif
 
    resize(400,380);

    statusBar();
    statusBar()->message("Ready...");

    // Create a menubar.
    newfileMenu = new QPopupMenu(this);
    int groupID = newfileMenu->insertItem("Group", this, SLOT(newGroupItem()));
    int hostID = newfileMenu->insertItem("Host", this, SLOT(newHostItem()), CTRL+Key_N);
    int moduleID = newfileMenu->insertItem("Plugin", this, SLOT(notimplemented()));
    newfileMenu->setItemEnabled(moduleID, false);
    
    // Start fileMenu...
    fileMenu = new QPopupMenu(this);
    fileMenu->insertItem("&New", newfileMenu);
    fileMenu->insertItem("&Save", this, SLOT(saveHostsFile()), CTRL+Key_S);
    fileMenu->insertSeparator();
    int PrintID = fileMenu->insertItem("Print", this, SLOT(notimplemented()));
    fileMenu->insertSeparator();
    fileMenu->insertItem("Quit", qApp, SLOT(quit()), CTRL+Key_Q);
    fileMenu->setItemEnabled(PrintID, false);
    menuBar()->insertItem("&File", fileMenu);
 	
    // Start editMenu...
    editMenu = new QPopupMenu(this);
    int undoID = editMenu->insertItem("Undo", this, SLOT(notimplemented()), CTRL+Key_Z);
    int redoID = editMenu->insertItem("Redo", this, SLOT(notimplemented()), CTRL+Key_D);
    editMenu->insertSeparator();
    int copyID = editMenu->insertItem("Copy", this, SLOT(notimplemented()), CTRL+Key_C);
    int cutID = editMenu->insertItem("Cut", this, SLOT(notimplemented()), CTRL+Key_X);
    int pasteID = editMenu->insertItem("Paste", this, SLOT(notimplemented()), CTRL+Key_V);
    editMenu->insertSeparator();
    /*int renameID =*/ editMenu->insertItem("Rename", this, SLOT(renameItem()));
    editMenu->insertSeparator();
    /*int prefID =*/ editMenu->insertItem("Preferences...", this, SLOT(preferences()));
    editMenu->setItemEnabled(undoID, false);
    editMenu->setItemEnabled(redoID, false);
    editMenu->setItemEnabled(copyID, false);
    editMenu->setItemEnabled(cutID, false);
    editMenu->setItemEnabled(pasteID, false);
    menuBar()->insertItem("&Edit", editMenu);

    // Start hostMenu...
    hostMenu = new QPopupMenu(this);
    hostPropID = hostMenu->insertItem("Propert&ies...", this, SLOT(nosuchslot()), CTRL+Key_I);
    hostMenu->setItemEnabled(hostPropID, false);
    hostSyncID = hostMenu->insertItem("Syncing...");
    hostMenu->setItemEnabled(hostSyncID, false);
    hostMenu->insertSeparator();
    hostConnectID = hostMenu->insertItem("Connect", this, SLOT(nosuchslot()), CTRL+Key_Up);
    hostMenu->setItemEnabled(hostConnectID, false);
    hostDisconnectID = hostMenu->insertItem("Disconnect", this, SLOT(nosuchslot()), CTRL+Key_Down);
    hostMenu->setItemEnabled(hostDisconnectID, false);
    hostPingID = hostMenu->insertItem("Ping");
    hostMenu->setItemEnabled(hostPingID, false);    
    menuBar()->insertItem("&Host", hostMenu);
    
    // Start viewMenu...
    viewMenu = new QPopupMenu(this);
    int showtreeID = viewMenu->insertItem("Show Tr&ee", this, SLOT(notimplemented()));
    viewMenu->insertSeparator();
    int iconviewID = viewMenu->insertItem("Icon View", this, SLOT(notimplemented()));
    int textviewID = viewMenu->insertItem("Text View", this, SLOT(notimplemented()));
    int longviewID = viewMenu->insertItem("Long View", this, SLOT(notimplemented()));
    int shortviewID = viewMenu->insertItem("Short View", this, SLOT(notimplemented()));
    viewMenu->insertSeparator();
    int reloadtreeID = viewMenu->insertItem("Rel&oad Tree", this, SLOT(notimplemented()));
    viewMenu->setItemEnabled( showtreeID, false);
    viewMenu->setItemEnabled( iconviewID, false);
    viewMenu->setItemEnabled( textviewID, false);
    viewMenu->setItemEnabled( longviewID, false);
    viewMenu->setItemEnabled( shortviewID, false);
    viewMenu->setItemEnabled( reloadtreeID, false);
    menuBar()->insertItem("View", viewMenu);

    // put the seperator in
    menuBar()->setSeparator( QMenuBar::InWindowsStyle );
    menuBar()->insertSeparator();
    
    // Start helpMenu...
    helpMenu = new QPopupMenu(this);
    helpMenu->insertItem("Manual",client, SLOT(execHelp()), Key_F1);
    helpMenu->insertSeparator();
    helpMenu->insertItem("About", this, SLOT(about()), CTRL+Key_H);
    helpMenu->insertItem("About Qt", this, SLOT(aboutQt()));
    menuBar()->insertItem("Help", helpMenu);
    

    QSplitter* splitter = new QSplitter(this);
    splitter->setOpaqueResize(true);
    
    // Create the listview
    listview = new mainListView(splitter);
    listview->resize( 400, 300 );
    newfileMenu->connectItem(groupID, listview, SLOT(newGroupItem()));
    newfileMenu->connectItem(hostID, listview, SLOT(newHostItem()));

    // set the currentItem to something not null
    listview->currentItemSet(listview->firstChild(),true);
    
    // if the first item is a host, set the host properties dialog
    if (! listview->currentItemGet()->isExpandable())
    {
        enableHostPropItem(true, true);
    }

    //// Create the listbox
    listbox = new mainListBox(splitter);
    listbox->resize(200,300);
    listbox->setSelectionMode(QListBox::Multi);	

    boxandviewcommunication();

    // Show the splitter and set the main widget for the object...

    splitter->show();
    setCentralWidget( splitter );

    // show the initial list in the listbox
    listbox->setDisplayItem();

    #ifdef DEBUG
        debug("mainWindow::mainWindow() -> end of constructor");
    #endif
}

mainWindow::~mainWindow()
{
    #ifdef DEBUG
        debug("mainWindow::~mainWindow() -> deconstructing");
    #endif
}

// this is a slot that turns the hostPropItem in the Properties Menu on & off
void mainWindow::enableHostPropItem(bool on_off, bool list)
{
    /* disconnect the menu from the listbox */
    hostMenu->disconnectItem(hostPropID, listbox, SLOT(hostProperties()));
    /*hostMenu->disconnectItem(hostSyncID, listbox, SLOT(hostProperties()));
    hostMenu->disconnectItem(hostConnectID, listbox, SLOT(hostProperties()));
    hostMenu->disconnectItem(hostDisconnectID, listbox, SLOT(hostProperties()));
    hostMenu->disconnectItem(hostPingID, listbox, SLOT(hostProperties()));*/
    
    /* disconnect the menu from the listview */
    hostMenu->disconnectItem(hostPropID, listview, SLOT(hostProperties()));
    /*hostMenu->disconnectItem(hostSyncID, listview, SLOT(hostProperties())); */
    hostMenu->disconnectItem(hostConnectID, listview, SLOT(connectToHost()));
    hostMenu->disconnectItem(hostDisconnectID, listview, SLOT(disconnectFromHost()));
    hostMenu->disconnectItem(hostPingID, listview, SLOT(startPing()));
    
    /* turn the items on or off */
    hostMenu->setItemEnabled(hostPropID, on_off);
    /*hostMenu->setItemEnabled(hostSyncID, on_off); */
    hostMenu->setItemEnabled(hostConnectID, on_off);
    hostMenu->setItemEnabled(hostDisconnectID, on_off);
    hostMenu->setItemEnabled(hostPingID, on_off);
            
    /* if we are turning stuff of, connect it up */
    if (on_off)
    {
        if (list)
        {
            hostMenu->connectItem(hostPropID, listview, SLOT(hostProperties()));
            /* hostMenu->connectItem(hostSyncID, listview, SLOT(notImplemented()));*/            
            hostMenu->connectItem(hostConnectID, listview, SLOT(connectToHost()));
            hostMenu->connectItem(hostDisconnectID, listview, SLOT(disconnectFromHost()));
            hostMenu->connectItem(hostPingID, listview, SLOT(startPing()));
        }
        else
        {
            hostMenu->connectItem(hostPropID, listbox, SLOT(hostProperties()));
            /* hostMenu->connectItem(hostSyncID, listbox, SLOT(notImplemented()));         
            hostMenu->connectItem(hostConnectID, listbox, SLOT(connectToHost()));
            hostMenu->connectItem(hostDisconnectID, listbox, SLOT(disconnectToHost()));
            hostMenu->connectItem(hostPingID, listbox, SLOT(startPing()));*/   
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// this is used as a temporary connector... don't delete.
///////////////////////////////////////////////////////////////////////////////

void mainWindow::notimplemented()
{
    QMessageBox::information( this, "Not Implemented",
    "This function is not yet implemented...\n\n"
    "Please visit http://www.mountlinux.com/olympus/ for updated information..."
    );
}
