/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    boxandviewcommunication.cc
*
*    Description:
*
*****************************************************************************/

#include "olympus.h"
#include "mainWindow.h"
#include "mainListBox.h"
#include "mainListView.h"

#include <qlistbox.h>
#include <qmessagebox.h>
#include <qstatusbar.h>

void mainWindow::boxandviewcommunication()
{
    #ifdef DEBUG
        debug("mainWindow::boxandviewcommunication() -> Start of function.");
    #endif

    // connect the list widgets to the mainWindow items (menus, status bar, etc)
    QObject::connect(listview, SIGNAL(enableHostPropItem(bool, bool)), this, SLOT(enableHostPropItem(bool, bool)));
    QObject::connect(listbox, SIGNAL(statusMessage(const QString &)), statusBar(), SLOT(message(const QString &)));
    QObject::connect(listbox, SIGNAL (enableHostPropItem(bool, bool)), this, SLOT (enableHostPropItem(bool, bool)));

    //  do a bunch of connecting signals and slots tween the list widgets
    QObject::connect(listview, SIGNAL (itemSelected(groupObj*)), listbox, SLOT (setDisplayItem(groupObj*)));
    QObject::connect(listview, SIGNAL (itemSelected(hostObj*)), listbox, SLOT (setDisplayItem(hostObj*)));

    #ifdef DEBUG
        debug("mainWindow::boxandviewcommunication() -> End of function.");
    #endif
}

void mainWindow::saveHostsFile()
{
    client->saveHostsFile();
    QMessageBox::information(0, "File Saved", "Your Hosts Configuration Has Been Saved.");
}