/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	newHostItem.cc 
*	
*	this creates new host items in the mainListView widget
*
*****************************************************************************/

#include "olympus.h"
#include "mainListView.h"
#include "hostItem.h"
#include "hostGroup.h"
#include "hostObj.h"

void mainListView::newHostItem() 
{
	//  the item that is selected, if any  
	QListViewItem * itemSelected = currentItem;
	setSelected(itemSelected,true);
	
	if (! itemSelected) //  if there is no item, create it at the top level  
	{
		new hostObj(client->hostRoot, true, "New Host");
	}
	else // otherwise, lets find out the parent and put it there...
	{
		if (itemSelected->isExpandable()) // group selected. so lets put it there
		{
			new hostObj(((hostGroup *) itemSelected)->getGroupObj(), true, "New Host");
			itemSelected->setOpen(true);
		}
		else  //  it is a host item... find the parent, put it there 
		{
    		new hostObj(((hostItem*) itemSelected)->hostInfo()->getParent(), true, "New Host");
    		if (itemSelected->depth() > 0) { itemSelected->parent()->setOpen(true); }
		}
	}
}