/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	newHostItem.cc 
*	
*	this creates new host items in the mainListView widget
*
*   Aaron J. Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "olympus.h"
#include "mainListView.h"
#include "hostGroup.h"
#include "hostItem.h"
#include "groupObj.h"
#include "hostObj.h"

//#define DEBUG_NEWGROUP

void mainListView::newGroupItem() 
{

    #ifdef DEBUG_NEWGROUP
        debug("\nmainlistView::newGroupItem >>  starting to place new group");
    #endif
    
	//  the item that is selected, if any  
	QListViewItem * itemSelected = currentItem;
	hostGroup * newItem;
	
	//  if there is no item, create it at the top level  
	if (! itemSelected) 
	{
		new groupObj(client->hostRoot);		
	}
	else // otherwise, lets find out the parent and put it there...
	{  
		if (itemSelected->isExpandable()) // group selected. so lets put it there 
		{
			new groupObj(((hostGroup *) itemSelected)->getGroupObj());
			itemSelected->setOpen(true);
		}
		else //  it is a host item... find the parent, put it there 
		{	
			new groupObj(((hostItem*) itemSelected)->hostInfo()->getParent());
			if (itemSelected->depth() > 0) { itemSelected->parent()->setOpen(true); }
		}	
	}
	
    #ifdef DEBUG_NEWGROUP
        debug("mainlistView::newGroupItem >>  finished placing new group\n");
    #endif
}