/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	mouseEvents.cc 
*	
*	methods to handle the mouse events associated with the mainListView widget
*
*****************************************************************************/

#include "mainListView.h"

#include <qlist.h>

void mainListView::multiSelect(QListViewItem * fromItem, QListViewItem * toItem)
{
		QListViewItem * testItem; 
		
		// Reset any directories selected.
		testItem = firstChild();
		while (testItem != NULL) 
		{
			if (testItem->isSelected() && testItem->isExpandable()) setSelected(testItem, false);
			testItem = testItem->itemBelow();
		}
	    // Select all hosts (not expandable) between from item and to item
		testItem = fromItem;
		bool selectForward = toItem->itemPos() > testItem->itemPos();
		while ((testItem != NULL) && (testItem != toItem)) 
		{
			testItem->setSelected(true);
			
			if (selectedItems->find(testItem) < 0) { selectedItems->append(testItem); }
			
			if (selectForward) { testItem = testItem->itemBelow(); }
			else { testItem = testItem->itemAbove(); }
		}
		
		multiSelectFlag = true;
		
}