/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	moveItems.cc 
*	
*	methods to move selected items from one place to another in the list
*	moveTo is the item everything should be moved under
*	thisItem is the first item in the list to work from, should be started with
*		mainListView->firstChild();
*****************************************************************************/

#include "olympus.h"
#include "mainListView.h"
#include "hostItem.h"
#include "hostGroup.h"
#include "hostObj.h"
#include "groupObj.h"

#include <qlist.h>

//#define DEBUGDND

void mainListView::moveItems(QListViewItem* moveTo) 
{
	#ifndef DEBUGDND
		debug("\nmainListView DND >>  movement commencing..");
	#endif
	
	groupObj* destination;
	QListViewItem* itemToMove = selectedItems->first();
	bool hostMoved = false;
	bool groupMoved = false;
	
	if (moveTo == NULL) { destination = client->hostRoot; }
	else if (moveTo->isExpandable()) { destination = ((hostGroup*) moveTo)->getGroupObj(); moveTo->setOpen(true); }
	else { destination = ((hostItem*) moveTo)->hostInfo()->getParent(); }
	
	// the confirmation box you see when you delete something. text is unset here.
	emit enterLimbo();
    limbo = true;
	
	while(itemToMove != NULL)
	{
	    if (itemToMove->isExpandable())
        {
            hostGroup* thisGroup = (hostGroup*) itemToMove;
            
            if (! thisGroup->isDoomed()) 
            {
                if (destination == client->hostRoot || thisGroup->getGroupObj()->getParentGroup() == client->hostRoot)
                { groupMoved = true; }
                
                destination->parent(thisGroup->getGroupObj());
            }            
        }
        else
        {
            hostItem* thisItem = (hostItem*) itemToMove;
            
            if (! thisItem->isDoomed())
            {
                if (destination == client->hostRoot || thisItem->hostInfo()->getParent() == client->hostRoot)
                { hostMoved = true; }
                
                destination->parent(thisItem->hostInfo());
            }
            
            hostMoved = true;
        }
        
        itemToMove = selectedItems->next();
	}
	
	emit exitLimbo();
	limbo = false;
	
    if (hostMoved) { loadHosts(); }
	if (groupMoved) { loadGroups(); }
	
	#ifndef DEBUGDND
		debug("mainListView DND >>  movements complete\n");
	#endif
}