/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mouseEvents.cc 
*   
*   methods to handle the mouse events associated with the mainListView widget
*
*   Aaron Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "mainListView.h"

#include "hostItem.h"
#include "hostGroup.h"
#include "icons.h"

#include <qapplication.h>
#include <qlineedit.h>
#include <qlist.h>
#include <qpopupmenu.h>
#include <qtimer.h>

//#define MAINLIST_MOUSE

/* this handles selecting, etc of the items on the tree */
void mainListView::contentsMousePressEvent(QMouseEvent * mouseEvent)
{
    #ifdef MAINLIST_MOUSE
        debug("\nmainListView >>  mouse event >> entering mouse click handler");
    #endif
    /*  this is what was clicked on... we hope =)  */
    QListViewItem * itemClicked = itemAt(contentsToViewport(mouseEvent->pos()));
    QListViewItem * testItem;
    
    /*  if there is no item clicked on, get out1
        this avoids a core dump.  */
    if (! itemClicked) 
    { 
        #ifdef MAINLIST_MOUSE
            debug("mainListView >>  mouse event >> no item clicked...");
        #endif
        if (mouseEvent->button() == RightButton)
        {
            rightClickNoneMenu->exec(mouseEvent->globalPos());
        }
        return;
    }
        
    // reset the multiSelectFlag for the people below
    multiSelectFlag = false;

    #ifdef MAINLIST_MOUSE
        debug("mainListView >>  mouse event >> now starting the main decision");
    #endif
    
    // The Shift button was pressed
    if (mouseEvent->state() & ShiftButton) 
    {
        #ifdef MAINLIST_MOUSE
            debug("mainListView >>  mouse event >> shift button held...");
        #endif
        multiSelect(currentItemGet(),itemClicked);
        itemClicked->setSelected(true);
    }
    /*  now hand the control button  */
    else if (mouseEvent->state() & ControlButton) 
    {   
        #ifdef MAINLIST_MOUSE
            debug("mainListView >>  mouse event >> control button held...");
        #endif
        itemClicked->setSelected(true);
        if (selectedItems->find(itemClicked) < 0)
        {
            selectedItems->append(itemClicked);
        }
        else { selectedItems->remove(); }
    }
    else
    {
        #ifdef MAINLIST_MOUSE
            debug("mainListView >>  mouse event >> vanilla click...");
        #endif
        if (! itemClicked->isSelected())
        {
            clearSelection();
            selectedItems->clear();
        }
        
        setSelected(itemClicked, true);
        
        if (selectedItems->find(itemClicked) < 0)
        {
            selectedItems->append(itemClicked);
        }
        else if (mouseEvent->button() != RightButton) 
        {
            selectedItems->remove();
        }
    }
    
    currentItemSet(itemClicked);
    
    if (itemClicked->isExpandable()) { emit itemSelected(((hostGroup*) itemClicked)->getGroupObj()); }
    else { emit itemSelected(((hostItem*) itemClicked)->hostInfo()); }
    
    /*  pop out signals for a right mouse button clicked  */
    if (mouseEvent->button() == RightButton)
    {
        if (itemClicked->isExpandable()) /*  if it is a group item...  */
        {
            emit rightButtonOnGroup(itemClicked, mouseEvent->globalPos());
        }
        else /*  if it is a host item...  */
        {
            emit rightButtonOnHost(itemClicked, mouseEvent->globalPos());
        }
    }
    
    #ifdef MAINLIST_MOUSE
        debug("mainListView >>  mouse event >> exiting mouse click handler\n");
    #endif
}

/*
    the mouse is moving
    here we check for drags and such stuff within the widget
*/
void mainListView::contentsMouseMoveEvent(QMouseEvent * mouseEvent)
{   
    QListViewItem * itemClicked = itemAt(contentsToViewport(mouseEvent->pos()));
    // we don't do groups. yet.
    if (itemClicked == NULL) 
    { 
        return;
    }
    
    if (mouseEvent->state() & LeftButton && !dragging && !itemClicked->isExpandable())
    {
        QPixmap itemIcon;
        icon_small->find("olympus-defaultItem",itemIcon);
        
        dragging = true;
        
        QApplication::setOverrideCursor(QCursor(itemIcon));
    }
    else if (dragging &&
            (contentsToViewport(mouseEvent->pos()).x() >= 0) && 
            (contentsToViewport(mouseEvent->pos()).x() <= visibleWidth()))
    {
        setCurrentItem(itemClicked);
    }
    
    
    /* Set up a timer to scroll the view if necessary */
    if (contentsToViewport(mouseEvent->pos()).y() < 0) {
        if (!scrollTimerActive) {
            scrollTimerActive = true;
            scrollTimer = new QTimer();
            QObject::connect(scrollTimer, SIGNAL(timeout()), this, SLOT(scrollUp()));
            scrollTimer->start(50);
        }
    } 
    else if (contentsToViewport(mouseEvent->pos()).y() > visibleHeight()) { 
        if (!scrollTimerActive) {
            scrollTimerActive = true;
            scrollTimer = new QTimer();
            QObject::connect(scrollTimer, SIGNAL(timeout()), 
            this, SLOT(scrollDown()));
            scrollTimer->start(50);
        }
    }
    else if (scrollTimerActive) {
        scrollTimerActive = false;
        delete scrollTimer;
    }
}

/*
    the mouse button is released
    here we catch drags and such stuff within the widget
*/
void mainListView::contentsMouseReleaseEvent(QMouseEvent *mouseEvent)
{
    QListViewItem *itemClicked = itemAt(contentsToViewport(mouseEvent->pos()));

    // Reset any scrolling timers that might exist
    if (scrollTimerActive) 
    {
        scrollTimerActive = false;
        delete scrollTimer;
    }
    
    if (dragging)
    {
        dragging = false;
        
        // Reset the mouse cursor
        QApplication::restoreOverrideCursor();
        
        if ((contentsToViewport(mouseEvent->pos()).x() >= 0) && 
            (contentsToViewport(mouseEvent->pos()).x() <= visibleWidth()))
        {
            moveItems(itemClicked);
        } 
            else 
        {
            QApplication::beep();
        }
        
        shiftStartItem = NULL;
    } 
}


void mainListView::wheelEvent(QWheelEvent * mouseEvent)
{
    if (mouseEvent->delta() > 0)
    {
        scrollUp();
    }
    else if (mouseEvent->delta() < 0)
    {
        scrollDown();   
    }
}

/*  kicks up the rightClickMenu as defined in mainListView.cc  */
void mainListView::launchRightClickMenu( QListViewItem * thisItem, const QPoint & thePoint)
{
    if (thisItem->isExpandable())
    {
        rightClickGroupMenu->exec(thePoint);
    }
    else
    {
        rightClickHostMenu->exec(thePoint);
    }
} 
