/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	makeVisible.cc 
*	
*	give it an item, it'll make sure you can see it.
*
*****************************************************************************/

#include "mainListView.h"

#include "hostGroup.h"
#include "hostItem.h"

void mainListView::makeVisible(QListViewItem * target = NULL)
{
	if (target == NULL) { return; }
	if (target->isExpandable())
	{
		hostGroup * group = (hostGroup *) target;

		if (((QListViewItem *) group)->parent() != 0 && ! ((QListViewItem *) group)->parent()->isOpen())
		{
			makeVisible(((QListViewItem *) group)->parent());
		}
		
		if (! group->isOpen())
		{
			group->setOpen(true);
		}
	}
	else
	{
		hostItem * host = (hostItem *) target;
		
		if (((QListViewItem*) host)->parent() != 0 && ! ((QListViewItem*) host)->parent()->isOpen())
		{
			makeVisible(((QListViewItem *) host)->parent());
		}
	}
}