/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mainListView.cc 
*   
*   A subclass of QListView. It appears in the left pane of the main
*   client window.
*
*****************************************************************************/

#include "olympus.h"
#include "mainListView.h"
#include "hostItem.h"

#include <qpopupmenu.h>
#include <qheader.h>
#include <qlist.h>

mainListView::mainListView(QWidget * parent)   
    : QListView(parent)
{
    #ifdef DEBUG
        debug("mainListView::mainListView() -> start of constructor");
    #endif

    /* initialize the vars */
    shiftSelectionFlag = false;
    multiSelectFlag = false;
    limbo = false;
    
    /*  give the list some flavour by specifying some options */
    setAllColumnsShowFocus ( true );
    setRootIsDecorated( true );
    setSorting(-1);
    setFrameStyle(StyledPanel | Sunken);
    setMultiSelection(true);
    
    selectedItems = new QList<QListViewItem>;
    
    /* the one and only column */
    addColumn( "Hosts" );
    setColumnWidth(0,288);
    
    /* make the header non clickable */
    this->header()->setClickEnabled(false);
    
    /*  addColumn( "Sync" );  */
    
    /*  the host group and host item right click menus  */  
    rightClickNoneMenu = new QPopupMenu(this,"rightClickGroupMenu");
    rightClickNoneMenu->insertItem("New Group", this, SLOT ( newTopGroupItem() ) );
    rightClickNoneMenu->insertItem("New Host...", this, SLOT ( newTopHostItem() ) );
    
    rightClickGroupMenu = new QPopupMenu(this,"rightClickGroupMenu");
    rightClickGroupMenu->insertItem("Rename", this, SLOT ( groupProperties() ) );
    int syncingID = rightClickGroupMenu->insertItem("Syncing...");
    rightClickGroupMenu->setItemEnabled(syncingID, false);
    rightClickGroupMenu->insertSeparator();
    rightClickGroupMenu->insertItem("New Group", this, SLOT ( newGroupItem() ) );
    rightClickGroupMenu->insertItem("New Host...", this, SLOT ( newHostItem() ) );
    rightClickGroupMenu->insertItem("Add/Remove Modules...", this, SLOT (groupModules()));
    rightClickGroupMenu->insertSeparator();
    rightClickGroupMenu->insertItem("Delete", this, SLOT ( deleteItems() ) );
        
    rightClickHostMenu = new QPopupMenu(this,"rightClickHostMenu");
    rightClickHostMenu->insertItem("Properties...", this, SLOT (hostProperties()), 0, 0);
    int syncing2ID = rightClickHostMenu->insertItem("Syncing...");
    rightClickHostMenu->setItemEnabled(syncing2ID, false);
    rightClickHostMenu->insertSeparator();
    rightClickHostMenu->insertItem("Connect", this, SLOT(connectToHost()), 0, 2);
    rightClickHostMenu->insertItem("Disconnect", this, SLOT(disconnectFromHost()),0, 3);
    rightClickHostMenu->setItemEnabled(3,false);
    rightClickHostMenu->insertItem("Ping", this, SLOT(startPing()),0, 4);
    rightClickHostMenu->insertSeparator();
    rightClickHostMenu->insertItem("New Group", this, SLOT (newGroupItem()),0, 5);
    rightClickHostMenu->insertItem("New Host...", this, SLOT (newHostItem()),0, 6);
    rightClickHostMenu->insertSeparator();
    rightClickHostMenu->insertItem("Delete", this, SLOT (deleteItems()),0, 7);
    QObject::connect(rightClickHostMenu, SIGNAL(aboutToShow()),
                     this, SLOT(checkConnection()));

    /* set the colours on the tree so it looks all purty */
    setPalette(*client->listPalette);
    
    /* connect the host groups to a right click menu */
    QObject::connect(this,
    SIGNAL (rightButtonOnGroup( QListViewItem *, const QPoint &)),
    this, 
    SLOT (launchRightClickMenu( QListViewItem *, const QPoint &)));

    /* connect the host items to a right click menu */
    QObject::connect(this,
    SIGNAL (rightButtonOnHost( QListViewItem *, const QPoint &)),
    this, 
    SLOT (launchRightClickMenu( QListViewItem *, const QPoint &)));

    setAcceptDrops(true);
    
    loadGroups();
    loadHosts();
        
    QObject::connect((QObject*) client->hostRoot, SIGNAL(updatedHosts()),
                     this, SLOT(loadHosts()));
    QObject::connect((QObject*) client->hostRoot, SIGNAL(updatedGroups()),
                     this, SLOT(loadGroups()));
    QObject::connect((QObject*) client->hostRoot, SIGNAL(updatedAll()),
                     this, SLOT(loadHosts()));
    QObject::connect((QObject*) client->hostRoot, SIGNAL(updatedAll()),
                     this, SLOT(loadGroups()));
    #ifdef DEBUG
        debug("mainListView::mainListView() -> end of constructor");
    #endif
}

mainListView::mainListView() 
{

}

mainListView::~mainListView()
{
    #ifdef DEBUG
        debug("mainListView::~mainListView() -> start of deconstructor");
    #endif
   
    #ifdef DEBUG
        debug("mainListView::~mainListView() -> end of deconstructor");
    #endif
}

QListViewItem* mainListView::nextGroupPos(char* name)
{
    QListViewItem* groupie = NULL;
    QListViewItem* marker = firstChild();
    int numChildren = childCount();
    int i = 0;

    while(i < numChildren && marker != NULL && 
          marker->isExpandable() == true && marker->text(0) < name) 
    { groupie = marker; marker = marker->nextSibling(); i++; }
    
    return groupie;
}


QListViewItem* mainListView::nextHostPos(char* name)
{
    QListViewItem* target = NULL;
    QListViewItem* marker = firstChild();
    int numChildren = childCount();
    int i = 0;
    
    while(i < numChildren && marker != NULL && marker->isExpandable() == true) 
    { target = marker; marker = marker->nextSibling();  i++; }
    
    while(i < numChildren && marker != NULL && marker->text(0) < name) 
    { target = marker; marker = marker->nextSibling();  i++; }
    
    return target;
}