/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   loadHosts.cc 
*   
*   Loads the list of hosts from client->hostRoot;
*
*****************************************************************************/

#include "olympus.h"
#include "mainListView.h"
#include "hostItem.h"
#include "hostGroup.h"
#include "hostObj.h"
#include "groupObj.h"

void mainListView::loadHosts()
{
    if (limbo) { return; }
    
    int numChildren = childCount();
    int i = 0;
    QListViewItem* deletions = firstChild();
    QListViewItem* temp;
    hostObj* thisHost = client->hostRoot->getFirstChild();
    currentItem = NULL;
    
    for (; i < numChildren; i++)
    {
       temp = deletions->nextSibling();
       if (deletions->isExpandable() == false) { delete deletions; }
       deletions = temp;
    }
    
    while (thisHost != NULL)
    {
        new hostItem(this, thisHost, thisHost->getCommonName()->data());
        thisHost = thisHost->getNext();
    }
}    

void mainListView::loadGroups()
{
    if (limbo) { return; }
    
    int numChildren = childCount();
    int i = 0;
    QListViewItem* deletions = firstChild();
    QListViewItem* temp;
    currentItem = NULL;
    
    for (; i < numChildren; i++)
    {
       temp = deletions->nextSibling();
       if (deletions->isExpandable() == true) { delete deletions; }
       deletions = temp;
    }
  
    groupObj* thisGroup = client->hostRoot->getChildGroup();
    
    while (thisGroup != NULL)
    {
        new hostGroup(this, thisGroup, thisGroup->getName()->data());
        thisGroup = thisGroup->getNext();
    }
}      

