/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	mouseEvents.cc 
*	
*	methods to handle the mouse events associated with the mainListView widget
*
*****************************************************************************/

#include "mainListView.h"

#include "hostItem.h"
#include "hostGroup.h"
#include "hostObj.h"

#include <qlineedit.h>

//#define MAINLIST_KEYS

void mainListView::keyPressEvent(QKeyEvent * keyEvent) {
	
	QListViewItem * thisItem = currentItemGet();
	
	if (thisItem == NULL) { return; }
	
    multiSelectFlag = false;	
    
	if (! thisItem) { return; }

	// up arrow key was pressed
	if ( keyEvent->key() == Key_Up) 
	{
		if (thisItem->itemAbove() != NULL)
		{
			if (! (keyEvent->state() == ShiftButton)) 
			{
				shiftSelectionFlag = false;
			}
			else if (! shiftSelectionFlag)
			{
				shiftSelectionFlag = true;
				shiftStartItem = currentItemGet();
			}
			
			clearSelection();
			currentItemSet(currentItemGet()->itemAbove(),true);
			
			if (keyEvent->state() == ShiftButton) {	multiSelect(shiftStartItem,currentItemGet()); }
			
			thisItem = currentItemGet();
			if (thisItem->isExpandable()) { itemSelected(((hostGroup*) thisItem)->getGroupObj()); }
			else { itemSelected(((hostItem*) thisItem)->hostInfo()); }
		}		
	}
	else if ( keyEvent->key() == Key_Down) // down arrow key was pressed
	{
		if (thisItem->itemBelow() != NULL)
		{
			if (! (keyEvent->state() == ShiftButton)) 
			{
				shiftSelectionFlag = false;			
			}
			else if (! shiftSelectionFlag)
			{
				shiftSelectionFlag = true;
				shiftStartItem = currentItemGet();
			}
			clearSelection();
			currentItemSet(currentItemGet()->itemBelow(),true);
			if (keyEvent->state() == ShiftButton) 
			{
				multiSelect(shiftStartItem,currentItemGet());
			}
			
			thisItem = currentItemGet();
			if (thisItem->isExpandable()) { itemSelected(((hostGroup*) thisItem)->getGroupObj()); }
			else { itemSelected(((hostItem*) thisItem)->hostInfo()); }
		}
	}
	else if ( keyEvent->key() == Key_Right) // right arrow key was pressed
	{
	    QPoint* posOfItem;
	    
	    if (thisItem != NULL) { posOfItem = new QPoint(columnWidth(0), itemPos(thisItem) + (thisItem->height() * 2)); }
	    else { posOfItem = new QPoint(columnWidth(0),0); }
       	
		if (thisItem->isExpandable())
		{
			setOpen(thisItem,true);
			if (keyEvent->state() == ControlButton) 
			{
				emit rightButtonOnGroup(thisItem, mapToGlobal(*posOfItem));
			}
		}
		else
		{
			emit rightButtonOnHost(thisItem, mapToGlobal(*posOfItem));
		}
		
		delete posOfItem;
	}
	else if ( keyEvent->key() == Key_Left) // left arrow key was pressed
	{
		setOpen(thisItem,false);
	}
	else if ( keyEvent->key() == Key_Enter || keyEvent->key() == Key_Return) // enter key was pressed
	{
		clearSelection();
		currentItemSet(thisItem,true);
		// open it if its a host group
		if (thisItem->isExpandable())
		{
			if (thisItem->isOpen())
			{
				thisItem->setOpen(false);
			}
			else
			{
				thisItem->setOpen(true);
			}
		}
	    else 
	    { 
	        ((hostItem*) thisItem)->hostInfo()->connect();
	    }
	}
	else if ( keyEvent->key() == Key_Delete )
	{
		deleteItems();
	}
}
