/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	hostConnections.cc 
*	
*	contains three functions:
*
*   checkConnection() turns on or off items in the rightClickHostMenu
*   connectToHost() connects to host
*   disconnectToHost() disconnects from host
*
*****************************************************************************/

#include "mainListView.h"
#include "hostItem.h"
#include "hostObj.h"

#include <qpopupmenu.h>

//#define DEBUG_DEBUGCONNECTION

void mainListView::checkConnection()
{
    #ifdef DEBUG_DEBUGCONNECTION
        debug("\nmainListView::checkConnection() >>  setting up host menu.");
    #endif
    
    hostItem* thisItem = (hostItem*) currentItemGet();
    if (thisItem->hostInfo()->isConnected())
    {
        rightClickHostMenu->setItemEnabled(2,false);
        rightClickHostMenu->setItemEnabled(3,true);    
    }
    else
    {
        rightClickHostMenu->setItemEnabled(2,true);
        rightClickHostMenu->setItemEnabled(3,false);
    }
    
    #ifdef DEBUG_DEBUGCONNECTION
        debug("\nmainListView::checkConnection() >>  finished setting up host menu.");
    #endif
}

void mainListView::connectToHost()
{
    hostItem* thisItem = (hostItem*) currentItemGet();
    thisItem->hostInfo()->connect();
}

void mainListView::disconnectFromHost()
{
    hostItem* thisItem = (hostItem*) currentItemGet();
    thisItem->hostInfo()->disconnect();
}