/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	mouseEvents.cc 
*	
*	methods to handle the mouse events associated with the mainListView widget
*
*****************************************************************************/

#include "mainListView.h"
#include "groupObj.h"
#include "hostGroup.h"
#include "hostItem.h"
#include "hostObj.h"

#include <qmessagebox.h>
#include <qlist.h>
#include <qlistview.h>

void mainListView::deleteItems() {
	/*  the item to delete, if any  */
	QListViewItem * itemToToast = selectedItems->first();	
	int kill = 0;
	bool hostsDirty = false;
	bool groupsDirty = false;
	
	// the confirmation box you see when you delete something. text is unset here.
	emit enterLimbo();
	limbo = true;
	
	/*  if there is no item, leave now or face a core dump  */
	while (itemToToast != NULL) 
	{
        if (itemToToast->isExpandable())
        {
            hostGroup* thisGroup = (hostGroup*) itemToToast;
            
            if (! thisGroup->isDoomed()) 
            {        
                // attempt to destroy the item and if successful, do housekeeping
                if ((kill = thisGroup->getGroupObj()->destroy(kill)) > 0)
                {
                    if (thisGroup->depth() < 1) { groupsDirty = true; }
                    else { ((hostGroup*) itemToToast->parent())->dirty(hostGroup::GROUPS); }
                    delete thisGroup->getGroupObj();
                }
            }
        }
        else
        {
            hostItem* thisItem = (hostItem*) itemToToast;
            
            if (! thisItem->isDoomed())
            {
                if ((kill = thisItem->hostInfo()->destroy(kill)) > 0)
                {
                    if (thisItem->depth() < 1) { hostsDirty = true; }
                    else { ((hostGroup*) itemToToast->parent())->dirty(hostGroup::HOSTS); }
                    delete thisItem->hostInfo();
                }
            }
        }
        
        itemToToast = selectedItems->next();
	} // while (itemToToast != 0)
    
    selectedItems->clear();
    clearSelection();
    multiSelectFlag = false;
    limbo = false;
    currentItem = NULL;
    
    if (hostsDirty) { loadHosts(); }
    if (groupsDirty) { loadGroups(); }
    
    emit exitLimbo();
}