/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	currentItemGetSet.cc 
*	
*	Routines for managing the currentItem object variable
*
*****************************************************************************/

#include "mainListView.h"

bool mainListView::currentItemSet( QListViewItem * newCurrent = NULL, bool selectIt = false) 
{
	//  if there is no ListViewItem passed to us, then lets go and 
	//  get the firstChild or else return with failure
	if (newCurrent == NULL)
	{
		if (firstChild())
		{
			newCurrent = firstChild();
		}
		else 
		{
		    currentItem = NULL;
			return false;
		}
	}
    
	currentItem = newCurrent;
	setCurrentItem(currentItem);

	if (selectIt && currentItem != NULL) 
	{
		currentItem->setSelected(true);
		ensureItemVisible(currentItem);
		repaintItem(currentItem);
	}
	
	if (! currentItem->isExpandable())
	{
		emit enableHostPropItem(true, true);
	}
	else
	{
		emit enableHostPropItem(false, true);
	}
	return true;
}

QListViewItem *  mainListView::currentItemGet() 
{
	if (currentItem == NULL) 
	{
		if (! currentItemSet(NULL,true))
		{
			return NULL;
		}
	}
	return currentItem;
}