/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainListBox.cc
*
*    sets the item to dislay in the list box
*
*    Aaron Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "olympus.h"
#include "mainListBox.h"

#include "groupObj.h"
#include "hostObj.h"
#include "icons.h"
#include "mainListBoxItem.h"
#include "module.h"
#include "moduleList.h"

#include <qpixmap.h>

void mainListBox::setDisplayItem() { setDisplayItem(client->hostRoot); }

void mainListBox::setDisplayItem(groupObj* itemToDisplay)
{
	QPixmap groupPix; 
	QPixmap hostPix;
	icon_small->find("olympus-groupItem", groupPix);
	icon_small->find("olympus-hostItem", hostPix);
	
	clear(); // clear the box first
	if (itemToDisplay == NULL) { itemToDisplay = client->hostRoot; }
	
	if (displayGroup != NULL)
	{
	    QObject::disconnect(displayGroup, SIGNAL(updatedHosts()),
	                        this, SLOT(refreshList()));
	    QObject::disconnect(displayGroup, SIGNAL(updatedGroups()),
	                        this, SLOT(refreshList()));
	    QObject::disconnect(displayGroup, SIGNAL(updatedAll()),
	                        this, SLOT(refreshList()));
	    QObject::disconnect(displayGroup, SIGNAL(lastCall()),
	                     this, SLOT(setDisplayItem()));
	}
	
	if (displayHost != NULL)
	{
	    QObject::disconnect(displayHost, SIGNAL(modulesChanged()),
	                        this, SLOT(refreshList()));;
	    QObject::disconnect(displayHost, SIGNAL(propsChanged()),
	                        this, SLOT(refreshList()));;
	    QObject::disconnect(displayHost, SIGNAL(lastCall()),
	                        this, SLOT(setDisplayItem()));		
	}
	
	groupObj* groups = itemToDisplay->getChildGroup();
	hostObj*  hosts  = itemToDisplay->getFirstChild();
    
    mainListBoxItem* newItem;
    
    if (itemToDisplay->getParentGroup() != NULL)
    {
	    newItem = new mainListBoxItem(".. (" + *itemToDisplay->getName() + ")", NULL, this, itemToDisplay->getParentGroup());
	    QObject::connect(itemToDisplay, SIGNAL(nameChanged(QString*)), newItem, SLOT(nameChanged()));
	}
	
	while (groups) 
	{
	    newItem = new mainListBoxItem(*groups->getName(), groupPix, this, groups);
	    QObject::connect(groups, SIGNAL(nameChanged(QString*)), newItem, SLOT(nameChanged()));
	    groups = groups->getNext();
	}
	    
	while (hosts)
	{
	    newItem = new mainListBoxItem(*hosts->getCommonName(), hostPix, this, hosts);
	    QObject::connect(hosts, SIGNAL(propsChanged()), newItem, SLOT(nameChanged()));
	    hosts = hosts->getNext();
    }

	currentItem = 0;
	setSelected(currentItem, true);				
	setCurrentItem(currentItem);
	displayHost = NULL;
    displayGroup = itemToDisplay;
	
	QObject::connect(itemToDisplay, SIGNAL(updatedHosts()),
	                 this, SLOT(refreshList()));
	QObject::connect(itemToDisplay, SIGNAL(updatedGroups()),
	                 this, SLOT(refreshList()));
	QObject::connect(itemToDisplay, SIGNAL(updatedAll()),
	                 this, SLOT(refreshList()));
	QObject::connect(itemToDisplay, SIGNAL(lastCall()),
	                 this, SLOT(setDisplayItem()));
	
	emit statusMessage("Ready...");	
}

void mainListBox::setDisplayItem(hostObj* itemToDisplay)
{
	QPixmap modulePix;
	icon_small->find("plugin-default", modulePix);

	clear(); // clear the box first
	if (itemToDisplay == NULL) { setDisplayItem(client->hostRoot);  }
	
	if (displayHost != NULL)
	{
	    QObject::disconnect(displayHost, SIGNAL(modulesChanged()),
	                        this, SLOT(refreshList()));;
	    QObject::disconnect(displayHost, SIGNAL(propsChanged()),
	                        this, SLOT(refreshList()));;
	    QObject::disconnect(displayHost, SIGNAL(lastCall()),
	                     this, SLOT(setDisplayItem()));	
	}
	
	if (displayGroup != NULL)
	{
	    QObject::disconnect(displayGroup, SIGNAL(updatedHosts()),
	                        this, SLOT(refreshList()));
	    QObject::disconnect(displayGroup, SIGNAL(updatedGroups()),
	                        this, SLOT(refreshList()));
	    QObject::disconnect(displayGroup, SIGNAL(updatedAll()),
	                        this, SLOT(refreshList()));
	    QObject::disconnect(displayGroup, SIGNAL(lastCall()),
	                        this, SLOT(setDisplayItem()));
	}

    moduleList* modules = itemToDisplay->getFirstModule();

    new mainListBoxItem(".. (" + *itemToDisplay->getCommonName() + ")", NULL, this, itemToDisplay->getParent());

	while (modules)
	{
	    new mainListBoxItem(*modules->getModuleName(), modulePix, this, modules);
	    modules = modules->getNextModule();
    }

	currentItem = 0;
	setSelected(currentItem, true);				
	setCurrentItem(currentItem);
	displayHost = itemToDisplay;
    	
    QObject::connect(itemToDisplay, SIGNAL(modulesChanged()),
	                 this, SLOT(refreshList()));
	QObject::connect(itemToDisplay, SIGNAL(propsChanged()),
	                    this, SLOT(refreshList()));;
	QObject::connect(itemToDisplay, SIGNAL(lastCall()),
	                 this, SLOT(setDisplayItem()));	

    displayGroup = NULL;    
	emit statusMessage("Ready...");	
}