/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mouseEvents.cc 
*   
*   methods to handle the mouse events associated with the mainListView widget
*
*   Aaron Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "mainListBox.h"

#include "mainListBoxItem.h"

#include <qlistview.h>

void mainListBox::multiSelect(int fromItem, int toItem)
{
    mainListBoxItem * testItem; 
    bool selectForward;
        
    // Select all hosts (not expandable) between from item and to item
    if (item(fromItem)->text().left(2) == "..") { fromItem++; }
    if (item(toItem)->text().left(2) == "..") { toItem++; }
    selectForward = (toItem > fromItem);
    
    while (! (fromItem == toItem)) 
    {
        testItem = (mainListBoxItem *) item(toItem);
        setSelected(toItem,true);
        if (selectForward) 
        {
            testItem = (mainListBoxItem *) item(--toItem);
        }
        else
        {
            testItem = (mainListBoxItem *) item(++toItem);
        }
    }
    
    testItem = (mainListBoxItem *) item(fromItem);
    setSelected(fromItem, true);
    
    multiSelectFlag = true;
}
