/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   mouseEvents.cc 
*   
*   methods to handle the mouse events associated with the mainListBox widget
*
*****************************************************************************/

#include "olympus.h"
#include "mainListBox.h"

#include "hostObj.h"
#include "groupObj.h"
#include "icons.h"
#include "mainListBoxItem.h"

#include <qapplication.h>
#include <qpopupmenu.h> 

//#define DEBUG_LISTBOXMOUSEEVENT

/* this handles selecting, etc of the items on the tree */
void mainListBox::mousePressEvent(QMouseEvent * mouseEvent)
{
    mainListBoxItem * itemClicked = (mainListBoxItem *) itemAt(contentsToViewport(mouseEvent->pos()));
    
    /*  if there is no item clicked on, get out as this avoids a core dump.  */
    if (! itemClicked) 
    { 
        clearSelection();
        return;
    }
    
    int itemClickedNo = index(itemClicked);
    
    // down mouse button! down mouse button! dwoo! dwoo!  @:oP
    if (! itemClicked->isType(mainListBoxItem::MODULE)) 
    {
        mouseHeld = true;
    }
    
    // reset the multiSelectFlag for the people below
    multiSelectFlag = false;

    // The Shift button was pressed
    if (mouseEvent->state() & ShiftButton) 
    {
        // don't include any .. entries in a multiselection
        if (itemClicked->text().left(2) == "..")
        {
            mouseHeld = false;
            itemClicked = (mainListBoxItem *) item(++itemClickedNo);    
        }
        
        if (item(currentItem))
        {
            multiSelect(itemClickedNo,currentItem);
        }
    }
    else if (mouseEvent->state() & ControlButton && 
             itemClicked->text().left(2) != "..") /*  handle control button  */
    {
        int i = 0;
        int numItems = count();
        mainListBoxItem* testItem = (mainListBoxItem *) item(i);
        
        while (i < numItems) 
        {
            // don't include any .. entries in a multiselection
            if (testItem->text().left(2) == "..") 
            { 
                setSelected(testItem, false); 
            }
            testItem = (mainListBoxItem *) item(++i);
        }
        multiSelectFlag = true;
        setSelected(itemClickedNo, true);
    }
    else  if (! multiSelectFlag) // and finally w/out a multiselect going on, do the following
    {       
        int numItems = count();
        for (int i = 0; i < numItems; i++)
        {
            setSelected(i,false);
        }
        setSelected(itemClickedNo, true);
    }

    currentItemSet(itemClickedNo, true);
    
    /*  pop out signals for a right mouse button clicked  */
    if (mouseEvent->button() == RightButton)
    {   
        mouseHeld = false; // avoid a drag/drop thing on right clicks
        /*  if it is a group item...  */
        if (itemClicked->isType(mainListBoxItem::GROUP)) 
        {
            emit rightButtonOnGroup(itemClicked, mouseEvent->globalPos());
        }
        /*  if it is a host item...  */
        else if  (itemClicked->isType(mainListBoxItem::HOST))
        {
            emit rightButtonOnHost(itemClicked, mouseEvent->globalPos());
        }
        else if (itemClicked->isType(mainListBoxItem::MODULE))
        {
        }
    }
    else if (! dragging)
    {
    }
}

/*
    the mouse is moving
    here we check for drags and such stuff within the widget
*/
void mainListBox::mouseMoveEvent(QMouseEvent * mouseEvent)
{   
    mainListBoxItem * itemClicked = (mainListBoxItem *) itemAt(contentsToViewport(mouseEvent->pos()));
    
    if (itemClicked == NULL) 
    { 
        emit statusMessage("Ready...");
        return; 
    }
    
    if (contentsToViewport(mouseEvent->pos()).x() < 10)
    {  
        emit statusMessage("Ready...");
    }
    else 
    {
        QString path;
        groupObj* thisGroup;
        
        if (itemClicked->text().left(2) != "..") { path.append(itemClicked->text()); }
        
        
        if (itemClicked->isType(mainListBoxItem::MODULE))
        { 
            path.prepend("/");
            path.prepend(*displayHost->getCommonName()); 
            thisGroup = displayHost->getParent();
        }
        else { thisGroup = displayGroup; }
        
        while (thisGroup != client->hostRoot && thisGroup != NULL)
        {
            path.prepend("/");
            path.prepend(*thisGroup->getName());
            thisGroup = thisGroup->getParentGroup();
        }
        
        path.prepend("Location: ");
        emit statusMessage(path);
    }   
    
    // and if we have a drag going down, we start the drag reflex...
    if (mouseHeld && dragging == false) 
    {
        if (itemClicked->isType(mainListBoxItem::MODULE) || 
            itemClicked->text().left(2) == "..")
        {
            mouseHeld = false;
        }
        else
        {
            QPixmap itemIcon;
            icon_small->find("olympus-defaultItem",itemIcon);
                    
            dragging = true;
                    
            QApplication::setOverrideCursor(QCursor(itemIcon));
        }   
    }
}

/*
    the mouse button is released
    here we catch drags and such stuff within the widget
*/
void mainListBox::mouseReleaseEvent(QMouseEvent *mouseEvent)
{
    #ifdef DEBUG_LISTBOXMOUSEEVENT
        debug("");
        debug("mainListBox::mouseReleaseEvent >>  starting a mouse up event");
    #endif
    
    mainListBoxItem * itemClicked = (mainListBoxItem *) itemAt(contentsToViewport(mouseEvent->pos()));
    
    // ok boyz, the mouse is up
    mouseHeld = false;
    
    if (itemClicked != NULL)
    {
        #ifdef DEBUG_LISTBOXMOUSEEVENT
            debug("mainListBox::mouseReleaseEvent >>  item was selected");
        #endif
    
        
        // if we aren't dragging and we are here
        if (dragging == false || itemClicked->isType(mainListBoxItem::MODULE))
        {
            #ifdef DEBUG_LISTBOXMOUSEEVENT
                debug("mainListBox::mouseReleaseEvent >>  not dragging");
            #endif
            
            setCurrentItem(index(itemClicked));
        }   
        else if ((contentsToViewport(mouseEvent->pos()).x() >= 0) && 
                (contentsToViewport(mouseEvent->pos()).x() <= visibleWidth())) // keep it in the borders
        {
            #ifdef DEBUG_LISTBOXMOUSEEVENT
                debug("mainListBox::mouseReleaseEvent >>  dragging");
            #endif
            
            if (itemClicked->isType(mainListBoxItem::GROUP))
            {
                #ifdef DEBUG_LISTBOXMOUSEEVENT
                    debug("mainListBox::mouseReleaseEvent >>  moving item");
                #endif
            
                limbo = true;
                mainListBoxItem * thisItem;
                groupObj * moveTo = itemClicked->displayGroup;
                
                // this loop performs the moving of the selected items
                unsigned int counter = count();
                for (int i = 0; i < counter; i++)
                {
                    thisItem = (mainListBoxItem *) item(i);
                    
                    if (isSelected(i) && 
                        thisItem->text().left(2) != "..")
                    {
                        if (thisItem->isType(mainListBoxItem::GROUP)) { moveTo->parent(thisItem->displayGroup); }
                        else if (thisItem->isType(mainListBoxItem::HOST)) { moveTo->parent(thisItem->displayHost); }                    }
                }
                limbo = false;
                // and of course, set the current item
                setDisplayItem(itemClicked->displayGroup);
                currentItemSet(0, true);
            }
            else 
            {
                QApplication::beep();
            }
        } // if (dragging)
        else // unsuccesful drag occurred
        {
            QApplication::beep();
        }       
    } // if itemClicked (in other code, we have an item clicked on)

    // an item might not have been clicked,
    // but some drag clean up is alway necessary
    if (dragging == true) 
    { 
        // Reset the mouse cursor
        QApplication::restoreOverrideCursor();
        // reset a shift start in case one is set
        shiftStartItem = 0; 
        // turn dragging off
        dragging = false;
    }

    #ifdef DEBUG_LISTBOXMOUSEEVENT
        debug("mainListBox::mouseMoveEvent >>  finished a mouse up event");
        debug("");
    #endif
}

void mainListBox::mouseDoubleClickEvent(QMouseEvent * mouseEvent)
{
    mainListBoxItem * itemClicked = (mainListBoxItem *) itemAt(contentsToViewport(mouseEvent->pos()));
    
    if (itemClicked == NULL) { return; }
    else if (itemClicked->isType(mainListBoxItem::MODULE)) { client->launchModule(itemClicked->displayModule,displayHost); }
    else if (itemClicked->isType(mainListBoxItem::GROUP)) { setDisplayItem(itemClicked->displayGroup); }
    else if (itemClicked->isType(mainListBoxItem::HOST))  { setDisplayItem(itemClicked->displayHost);  }
    else { setDisplayItem(); }
}

void mainListBox::wheelEvent(QWheelEvent * mouseEvent)
{
    if (mouseEvent->delta() > 0)
    {
        scrollUp();
    }
    else if (mouseEvent->delta() < 0)
    {
        scrollDown();   
    }
}

/*  kicks up the rightClickMenu as defined in mainListView.cc  */
void mainListBox::launchRightClickMenu(mainListBoxItem * thisItem, const QPoint & thePoint)
{
    if (thisItem->isType(mainListBoxItem::GROUP))
    {
        rightClickGroupMenu->exec(thePoint);
    }
    else if (thisItem->isType(mainListBoxItem::HOST))
    {
        rightClickHostMenu->exec(thePoint);
    }
} 