/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainListBoxItem.h
*
*    Description:...
*
*****************************************************************************/

#include "mainListBoxItem.h"

#include "groupObj.h"
#include "hostObj.h"
#include "mainListBox.h"

mainListBoxItem::mainListBoxItem( QString s, const QPixmap p, QListBox* parent, hostObj* itemToDisplay)
    : QListBoxItem(parent), pm(p)
{ 
    setText( s );
    displayHost = itemToDisplay;
    type = HOST;
}

mainListBoxItem::mainListBoxItem( QString s, const QPixmap p, QListBox* parent, groupObj* itemToDisplay)
    : QListBoxItem(parent), pm(p)
{ 
    setText( s );
    displayGroup = itemToDisplay;
    type = GROUP;
}

mainListBoxItem::mainListBoxItem( QString s, const QPixmap p, QListBox * parent, moduleList * itemToDisplay)
    : QListBoxItem(parent), pm(p)
{ 
    setText( s );
    displayModule = itemToDisplay;
    type = MODULE;
}

void mainListBoxItem::paint(QPainter *p)
{
    p->drawPixmap( 3, 0, pm );
    QFontMetrics fm = p->fontMetrics();
    int yPos;                       // vertical text position
    
    if ( pm.height() < fm.height() )
    {
        yPos = fm.ascent() + fm.leading()/2;
    }
    else
    {
        yPos = pm.height()/2 - fm.height()/2 + fm.ascent();
    }
    
    p->drawText( pm.width() + 5, yPos, text() );
}

int mainListBoxItem::height( const QListBox* lb ) const
{
    return QMAX( pm.height(), lb->fontMetrics().lineSpacing() + 1 );
}

int mainListBoxItem::width( const QListBox* lb ) const
{
    return pm.width() + lb->fontMetrics().width( text() ) + 6;
}

void mainListBoxItem::nameChanged()
{
    if (type == HOST && displayHost != NULL)
    {
        if (((mainListBox*) listBox())->host() != NULL &&
            displayGroup == ((mainListBox*) listBox())->host()->getParent()) { setText(".. (" + *displayHost->getCommonName() + ")"); }
        else { setText(*displayHost->getCommonName()); }
        listBox()->triggerUpdate(false);
    }
    else if (type == GROUP && displayGroup != NULL)
    {
        if (displayGroup == ((mainListBox*) listBox())->group()->getParentGroup()) { setText(".. (" + *displayGroup->getName() + ")"); }
        else { setText(*displayGroup->getName()); }
        listBox()->triggerUpdate(false);
    }
    else if (type == MODULE)
    {
    
    }
}