/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainListBox.cc
*
*    This holds the right hand of the splitter ... b'ah...b'ah...b'ah
*
*****************************************************************************/

#include "olympus.h"
#include "mainListBox.h"

#include <qpopupmenu.h>

mainListBox::mainListBox(QWidget* parent)
    : QListBox(parent)
{

    #ifdef DEBUG
        debug("mainListBox::mainListBox() -> start of constructor");
    #endif
    
    limbo = false;
    
    rightClickGroupMenu = new QPopupMenu(this,"rightClickGroupMenu");
    int clickGroupRenameID = rightClickGroupMenu->insertItem("Rename");
    rightClickGroupMenu->setItemEnabled(clickGroupRenameID, false);
    /*int rightClickGroupSyncingID = rightClickGroupMenu->insertItem("Syncing...");
    rightClickGroupMenu->setItemEnabled(rightClickGroupSyncingID, false);*/
    rightClickGroupMenu->insertSeparator();
    int rightClickGroupGroupID = rightClickGroupMenu->insertItem("New Group");
    int rightClickGroupMenuID = rightClickGroupMenu->insertItem("New Host...");
	rightClickGroupMenu->insertItem("Add/Remove Modules...", this, SLOT (groupModules()));
    rightClickGroupMenu->setItemEnabled(rightClickGroupGroupID, false);
    rightClickGroupMenu->setItemEnabled(rightClickGroupMenuID, false);
    rightClickGroupMenu->insertSeparator();
    int rightClickGroupDeleteID = rightClickGroupMenu->insertItem("Delete");
    rightClickGroupMenu->setItemEnabled(rightClickGroupDeleteID, false);
        
    rightClickHostMenu = new QPopupMenu(this,"rightClickHostMenu");
    /*int rightClickHostMenuSyncingID = rightClickHostMenu->insertItem("Syncing...");
    rightClickHostMenu->setItemEnabled(rightClickHostMenuSyncingID, false);*/

    setMouseTracking(true);
    setFixedWidth(250);
    
    /* set the colours on the tree so it looks all purty */
    setPalette(*client->listPalette);

    /* connect the host groups to a right click menu */
    QObject::connect(this,
    SIGNAL (rightButtonOnGroup(mainListBoxItem*, const QPoint &)),
    this, 
    SLOT (launchRightClickMenu(mainListBoxItem*, const QPoint &)));

    /* connect the host items to a right click menu */
    QObject::connect(this,
    SIGNAL (rightButtonOnHost(mainListBoxItem*, const QPoint &)),
    this, 
    SLOT (launchRightClickMenu(mainListBoxItem*, const QPoint &)));

    displayHost = NULL;
    displayGroup = NULL;
    
    setDisplayItem(client->hostRoot);

    #ifdef DEBUG
        debug("mainListBox::mainListBox() -> end of constructor");
    #endif

}


mainListBox::~mainListBox()
{
    #ifdef DEBUG
        debug("mainListBox::~mainListBox() -> start of deconstructor");
    #endif

    #ifdef DEBUG
        debug("mainListBox::~mainListBox() -> end of deconstructor");
    #endif
}
