/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	keyEvents.cc 
*	
*	methods to handle the key events associated with the mainListBox widget
*
*****************************************************************************/

#include "olympus.h"
#include "mainListBox.h"
#include "hostObj.h"
#include "groupObj.h"
#include "mainListBoxItem.h"

void mainListBox::keyPressEvent(QKeyEvent * keyEvent) {
	
	unsigned int thisItemNo = currentItem;
	mainListBoxItem * thisItem = (mainListBoxItem *) item(thisItemNo);
	//QPoint posOfItem(10,itemHeight(thisItemNo) * thisItemNo);
	multiSelectFlag = false;
	
	// up arrow key was pressed
	if ( keyEvent->key() == Key_Up) 
	{
		// make sure there is something above us (e.g. we are at at least item #1)
		if (thisItemNo > 0)
		{
			if (! (keyEvent->state() & ShiftButton)) 
			{
				shiftSelectionFlag = false;
			}
			else if (! shiftSelectionFlag)
			{
				shiftSelectionFlag = true;
				shiftStartItem = currentItem;
			}
			
			clearSelection();
			currentItemSet(thisItemNo - 1, true);
			
			if (keyEvent->state() == ShiftButton && thisItem->text().left(2) != "..") 
			{
				multiSelect(shiftStartItem,currentItem);
			}
		}
	}
	else if ( keyEvent->key() == Key_Down) // down arrow key was pressed
	{
		if (thisItemNo < (count() - 1)) // ensure there is something below
		{
			if (! (keyEvent->state() == ShiftButton))
			{

				shiftSelectionFlag = false;			
			}
			else if (! shiftSelectionFlag)
			{
				shiftSelectionFlag = true;
				shiftStartItem = currentItem;
			}
			clearSelection();
			currentItemSet(thisItemNo+1, true);
			if (keyEvent->state() == ShiftButton) 
			{
				multiSelect(shiftStartItem,currentItem);
			}
		}
	}
	else if (keyEvent->key() == Key_Left && 
	         thisItem->text().left(2) == "..") // left arrow key was pressed	
	{
		setDisplayItem(thisItem->displayGroup);	
    }
	else if (keyEvent->key() == Key_Right) // enter key / right key was pressed
	{
	    if (keyEvent->state() == ControlButton)
	    {
	        launchRightClickMenu(thisItem, mapToGlobal(QPoint(size().width() - 20, thisItemNo * itemHeight())));
	    }
		else if (thisItem->isType(mainListBoxItem::MODULE) && displayHost != NULL)
		{
			client->launchModule(thisItem->displayModule,displayHost);
		}
		else if (thisItem == NULL)
		{
			setDisplayItem();
		}	
		else
		{
		    if (thisItem->isType(mainListBoxItem::HOST))
		    { setDisplayItem(thisItem->displayHost); }
		    else if (thisItem->isType(mainListBoxItem::GROUP))
		    { setDisplayItem(thisItem->displayGroup); }
		}
	}
	else if (keyEvent->key() == Key_Enter || 
	         keyEvent->key() == Key_Return || 
	         keyEvent->key() == Key_Right) // enter key / right key was pressed
	{
		if (thisItem->isType(mainListBoxItem::MODULE) && displayHost != NULL)
		{
			client->launchModule(thisItem->displayModule,displayHost);
		}
		else if (thisItem == NULL)
		{
			setDisplayItem();
		}	
		else
		{
		    if (thisItem->isType(mainListBoxItem::HOST))
		    { setDisplayItem(thisItem->displayHost); }
		    else if (thisItem->isType(mainListBoxItem::GROUP))
		    { setDisplayItem(thisItem->displayGroup); }
		}
	}
	else if ( keyEvent->key() == Key_Delete )
	{
		deleteItems();
	}
}