/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	deleteItems.cc 
*	
*	methods to delete items
*
*****************************************************************************/

#include "mainListBox.h"

#include "mainListBoxItem.h"
#include "hostObj.h"
#include "groupObj.h"

void mainListBox::deleteItems()
{
	int numItems = count();
	int i = 0;
	int kill = 0;
	mainListBoxItem * thisItem = NULL;
	bool refreshNeeded =  false;
	
	limbo = true;
	
	for ( i = 0; i < count(); i++) 
	{
		// if it isn't a '..' entry...
		if (item(i)->text().left(2) != ".." && isSelected(i)) 
		{
		    thisItem = (mainListBoxItem*) item(i);
		    
		    if (thisItem->isType(mainListBoxItem::GROUP))
		    {
		        groupObj* group = thisItem->displayGroup;
		        
		        if ((kill = group->destroy(kill)) > 0)
                {
                    delete group;
                    refreshNeeded = true;
                }
		    }
		    else if (thisItem->isType(mainListBoxItem::HOST))
		    {
		        hostObj* host = thisItem->displayHost;
		        
		        if ((kill = host->destroy(kill)) > 0)
                {
                    delete host;
                    refreshNeeded = true;
                }
		    }
		    else if (thisItem->isType(mainListBoxItem::MODULE) && displayHost != NULL)
		    {
		        QString* name = new QString(thisItem->text());
		        displayHost->removeModule(name);
		        delete name;
		        refreshNeeded = true;
		    }
		}
	} 

    limbo = false;
    if (refreshNeeded) { refreshList(); }
}