/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	currentItemSet.cc 
*	
*	sets the current item up properly...
*
*   Aaron Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "mainListBox.h"

#include "mainListBoxItem.h"

void mainListBox::currentItemSet(int itemNo, bool select)
{
	if (itemNo < 0) { itemNo = 0; }
	if (! item(itemNo)) { return; }
	mainListBoxItem * thisItem = (mainListBoxItem *) item(itemNo);
	currentItem = itemNo;
	setCurrentItem(itemNo);
	setSelected(itemNo,select);
	
	// set the host properties menu item properly
	if (thisItem->text() == "..")
	{
		emit enableHostPropItem(false, false);
	}
	else if (thisItem->isType(mainListBoxItem::HOST))
	{
		emit enableHostPropItem(true, false);
	}
	else
	{
		emit enableHostPropItem(false, false);
	}
}