/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   writeOlympusFile.cc
*
*   Description:
*
*****************************************************************************/

#include "olympus.h"
#include "des.h"
#include "cipher.h"
#include "regexx.hh"
#include "split.hh"

using namespace regexx;

#include <qtextstream.h>

//for debugging...
//#define DEBUG_FILEIO
//#define DEBUG_CRYPTO            // don't enable for security reasons...

void olympus::writeOlympusFile(QTextStream *outPut)
{
    #ifdef DEBUG
        debug("olympus::writeOlympusFile() -> start of function");
    #endif

    QDictIterator<QString> it(*prefs);
    int depth = 1;

    #ifdef DEBUG_FILEIO
        debug("\n----------------------------------\n");
    #endif

    *outPut << "General {" << endl;
    while (it.current())
    {
        #ifdef DEBUG_FILEIO
            debug("%s=%s", it.currentKey().data(), it.current()->data());
            debug("\n----------------------------------\n");
        #endif

        if (Regexx(it.currentKey().data(), "defaultUsername") || Regexx(it.currentKey().data(), "defaultPassword"))
        {
            #ifdef DEBUG_CRYPTO
                debug("da. %s", it.currentKey().data());
            #endif

            //reset the initilization vector for the cipher
            QString *myQString = new QString(*it.current());
            client->clientCipher->resetIV();

            cipher *hexer = new cipher();

            char *tempHexed;
            unsigned char *crypted;

            crypted = client->clientCipher->encipher((unsigned char*) myQString->latin1(), (int)myQString->length());

            tempHexed = hexer->b10to16(crypted, client->clientCipher->padLength(myQString->length()));

            *outPut << tabs(depth) << it.currentKey() << " \"" << (char*)tempHexed << "\";" << endl;

            #ifdef DEBUG_CRYPTO
                debug("crypted: %s, tempHexed: %s", crypted, tempHexed);
            #endif

            delete tempHexed;
            delete crypted;
            delete myQString;
	    delete hexer;

            /* cryted ends up with the crypted text in it, and tempHexed
            has it ready for writing to a text file*/
        }
        else
        {
            #ifdef DEBUG_CRYPTO
                debug("da. no crypto needed.");
            #endif
            *outPut << tabs(depth) << it.currentKey() << " \"" <<  *it.current() << "\";" << endl;
        }

    ++it;
    }

    *outPut << "};" << endl;

    #ifdef DEBUG
        debug("olympus::writeOlympusFile() -> end of function");
    #endif
}
