/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   writeDefaultModulesFile.cc
*
*   Description:
*   This function will iterate over defaultModules and write out 
*   defaultmodules.conf
*
*****************************************************************************/

#include "olympus.h"
#include "module.h"
#include "moduleList.h"

#include <qfile.h>
#include <qmessagebox.h>
#include <qtextstream.h>

void olympus::writeDefaultModulesFile()
{
    #ifdef DEBUG
        debug("olympus::writeDefaultModulesFile() -> start of function");
    #endif

    QFile defaultModulesFile(*prefs->find("homePath") + defaultModulesFileName);
    QTextStream *outPut;
    
    if (!defaultModulesFile.open(IO_WriteOnly))
    {
        QMessageBox::warning(0, "Error!", "Error opening configuration file: defaultModules.conf\n\nWill not be able to save configuration files.\nPlease check file permissions");
        return;
    }
    else
    {
        outPut = new QTextStream(&defaultModulesFile);
    }
    
    
    moduleList *thisModule = defaultModules->getNextModule();        	
    int depth = 1;

    #ifdef DEBUG_FILEIO
        debug("\n----------------------------------\n");
    #endif

    *outPut << "defaultModules {" << endl;

    while (thisModule)
    {
        #ifdef DEBUG_FILEIO
            debug("name >> %s", thisModule->getModule()->getName()->data());
            debug("\n----------------------------------\n");
        #endif

        *outPut << tabs(depth) << "module \"" << *thisModule->getModule()->getName() << "\" {" << endl;
        *outPut << tabs(depth+1) << "group \"" << *thisModule->getModule()->getGroup() << "\";" << endl;
        *outPut << tabs(depth+1) << "version \"" << *thisModule->getModule()->getVersion() << "\";" << endl;
        *outPut << tabs(depth) << "};" << endl;

        thisModule = thisModule->getNextModule();
    }

    *outPut << "};" << endl;

    defaultModulesFile.close();
    delete outPut;

    #ifdef DEBUG
        debug("olympus::writeDefaultModulesFile() -> end of function");
    #endif
}
