/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   startupScreen.cc
*
*   Description: 
*   Implements a window that pops up with a welcome, some instructions and 
*   Licensing info for the user to accept or decline.
*
*****************************************************************************/

#include "olympus.h"

//#define DEBUG_STARTUP_SCREEN

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

int olympus::startupScreen()
{
    #ifdef DEBUG
        debug("olympus::startupScreen() -> Start of function ");
    #endif

    QDialog *startupScreen = new QDialog(0,"Mount Linux Olympus",true);        

    QLabel *startupLabel = new QLabel("<b>Mount Linux Olympus</b>", startupScreen, "startupLabel");
    startupLabel->setAlignment(QLabel::AlignCenter | QLabel::ExpandTabs);
    startupLabel->setTextFormat(QLabel::RichText);
    startupLabel->setFixedHeight(15);
    startupLabel->setAutoResize(true);

    QLabel * explainLabel = new QLabel(
    "<font size=3>"
    "Welcome to <A HREF=\"mountlinux.com\">Mount Linux</A> Olympus, an Open Framework for centralized remote configuration of Linux systems.<br><br>"
    "In the next window you will be asked to pick a new username and password which "
    "will be cryptograpically secured.<BR><BR>"
    "Use the same username and password the next time you log on.<br>"
    "<BR>Your login information can be changed at any time in the Preference dialog"
    "<BR><BR>"
    "<center><b>License:</b><br>"
    "Olympus version 0.3, Copyright (C) 1999-2000 of Mountlinux Inc. <BR>"
    "Licensed under the terms of GNU GPL 2.0; for details <br><br>"
    "<A HREF=\"http://www.gnu.org/copyleft/gpl.html\">http://www.gnu.org/copyleft/gpl.html</A><br><br>"
    "Click `Ok' to accept this license.<br>"
    "or click on `Cancel' to exit the program</center>"
    "<font>",
    startupScreen, "explainLabel");

    explainLabel->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    explainLabel->setAlignment(QLabel::AlignLeft | QLabel::AlignTop | QLabel::ExpandTabs | QLabel::WordBreak);
    explainLabel->setFixedWidth(420);
    explainLabel->setAutoResize(true);

    QPushButton *okButton = new QPushButton(startupScreen, "OkButton");
    okButton->setText("Ok");

    QPushButton *cancelButton = new QPushButton(startupScreen, "cancelButton");
    cancelButton->setText("Cancel");

    #ifdef DEBUG_STARTUP_SCREEN
        debug("Startup Screen >>  Laying out startup window");
    #endif

    QGridLayout * startupGrid = new QGridLayout(startupScreen,0,0,0,0,"startupLaout");

    startupGrid->addColSpacing(0, 10);
    startupGrid->addColSpacing(2, 30);
    startupGrid->addRowSpacing(0, 10);
    startupGrid->addMultiCellWidget(startupLabel, 1, 1, 1, 3);
    startupGrid->addRowSpacing(2, 10);
    startupGrid->addRowSpacing(3,explainLabel->heightForWidth(400));
    startupGrid->addMultiCellWidget(explainLabel, 3, 3, 1, 3);
    startupGrid->addRowSpacing(4, 10);
    startupGrid->addWidget(okButton, 5, 1);
    startupGrid->addWidget(cancelButton, 5, 3);
    startupGrid->addRowSpacing(6, 10);
    startupGrid->addColSpacing(4, 10);
    startupGrid->setColStretch(4, 20);
    startupGrid->setRowStretch(6, 20);

    startupScreen->setFixedSize(startupGrid->sizeHint());

    #ifdef DEBUG_STARTUP_SCREEN
        debug("Startup Screen >>  About to show");
    #endif

    QObject::connect(okButton, SIGNAL(clicked()), startupScreen, SLOT(accept()));
    QObject::connect(cancelButton, SIGNAL(clicked()), startupScreen, SLOT(reject()));

    if (startupScreen->exec())
    {
        #ifdef DEBUG
            debug("olympus::olympus -> Ok - startup process");
        #endif
        return 1;
    }
    else
    {
        #ifdef DEBUG
            debug("olympus::olympus -> Cancel - startup process");
        #endif

        return 0;
    }
}
