/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	setPassword
*	
*   Takes loginPassword and loginUsername from the olympus class and 
*	updates the username, userPassword and the auth file in .olympus/
*
*   Aaron Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include <qfile.h>

#include "olympus.h"
#include "des.h"

//#define DEBUG_SETPASSWORD

#include <qlineedit.h>

void olympus::setPassword() 
{
    #ifdef DEBUG_SETPASSWORD
        debug("");
        debug("Olympus Core >>  setPassword >>  updating username/password");
    #endif

    if (loginUsername == NULL || loginPassword == NULL)
    {
        return;
    }

    username->remove(0,-1);
    username->append(loginUsername->text()); 
    delete loginUsername;

    #ifdef DEBUG_SETPASSWORD
        debug("Olympus Core >>  setPassword >>  username updated");
    #endif

    password->remove(0,-1);
    password->append(loginPassword->text()); 
    delete loginPassword;

    #ifdef DEBUG_SETPASSWORD
        debug("Olympus Core >>  setPassword >>  password updated");
        debug("Olympus Core >>  setPassword >>  finished updating username/password");
        debug("");
    #endif
}

void olympus::setPasswordNoDelete() 
{
    #ifdef DEBUG_SETPASSWORD
        debug("");
        debug("Olympus Core >>  setPassword >>  updating username/password");
    #endif

    if (loginUsername == NULL || loginPassword == NULL)
    {
        return;
    }

    username->remove(0,-1);
    username->append(loginUsername->text());

    #ifdef DEBUG_SETPASSWORD
        debug("Olympus Core >>  setPassword >>  username updated");
    #endif

    password->remove(0,-1);
    password->append(loginPassword->text());

    #ifdef DEBUG_SETPASSWORD
        debug("Olympus Core >>  setPassword >>  password updated");
    #endif

    #ifdef DEBUG_SETPASSWORD
        debug("Olympus Core >>  setPassword >>  finished updating username/password");
        debug("");
    #endif
}
