/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   writeHostsFile.cc 
*   
*   this writes the listview out to a file upon destruction
*
******************************************************************************/

#include "olympus.h"
#include "groupObj.h"
#include "hostObj.h"
#include "module.h"
#include "moduleList.h"
#include "des.h"
#include "cipher.h"

#include <qfile.h>
#include <qmessagebox.h>
#include <qtextstream.h>

#define DEBUG_WRITEHOSTSFILE

void olympus::saveHostsFile()
{
	#ifdef DEBUG_WRITEHOSTSFILE
        debug("olympus::saveHostsFile() -> start of function");
    #endif
	
	QFile * hosts = new QFile(*prefs->find("homePath") + client->hostsFileName);
	
	// check to see if we can open it writeonly
	if (! hosts->open(IO_WriteOnly))
	{
		QString errorMessage("Olympus could not gain proper access to the file:\n\n          ");
		errorMessage.append(*prefs->find("homeFileName"));
		errorMessage.append("\n\nPlease check the file permissions.\n\nChanges in the host listing cannot be saved!!.");
		QMessageBox::critical(0,"Olympus:  Critical Error",errorMessage);		
		return;
	}
    
    // write the file out
	QTextStream outPut(hosts);
    
    hostObj* thisHost;
    groupObj* thisGroup = hostRoot;
    cipher* hexer = new cipher();
    int depth = 0;
    bool justUp = false;
    
    // reset the initialization vector in the cipher
    client->clientCipher->resetIV();

    while (thisGroup != NULL)
    {
    	#ifdef DEBUG_WRITEHOSTSFILE
            debug("olympus::saveHostsFile() -> got group %s", thisGroup->getName()->data());
        #endif

        if (justUp == false) {
        if (thisGroup != hostRoot) 
        { outPut << tabs(depth) << "group " << " \"" << *thisGroup->getName() << "\" {" << endl; }
        else { outPut << *thisGroup->getName() << " {" << endl; }
        }
        depth++;
        
        if (thisGroup->getChildGroup() != NULL && justUp == false)
        {
            thisGroup = thisGroup->getChildGroup();
        }
        else /* now do any hosts that it has in it, m'kay? */
        {
            justUp = false;
            
            if ((thisHost = thisGroup->getFirstChild()) > 0)
            {
                while (thisHost != NULL)
                {
                    outPut << tabs(depth) << "host \"" << thisHost->getCommonName()->data() << "\" {" << endl;
                    outPut << tabs(depth) << "\thostname \"" << thisHost->getHostname()->data() << "\";" << endl;
                    outPut << tabs(depth) << "\tport \"" << thisHost->getPort() << "\";" << endl;
                
                    if (thisHost->getUsername()->isNull())
                    {
                        #ifdef DEBUG_WRITEHOSTSFILE
                            debug("writeHostsFile >>  short circuiting");
                        #endif
                        outPut << tabs(depth) << "\tusername \"\";" << endl;
                    }
                    else
                    {
                        char * tempHexed;
                        unsigned char * crypted;
                        crypted = client->clientCipher->encipher((unsigned char *) thisHost->getUsername()->latin1(),(int) thisHost->getUsername()->length());
                        tempHexed = hexer->b10to16(crypted,
                                                client->clientCipher->padLength(thisHost->getUsername()->length()));
                        outPut << tabs(depth) << "\tusername \"" << (char *) tempHexed << "\";" << endl;
                        delete tempHexed;
                        delete crypted;
                    }
            
                    if (thisHost->weSavePassword())
                    {
                        if (thisHost->getUsername()->isNull())
                        {
                            outPut << tabs(depth) << "\tpassword \"\";" << endl;
                        }
                        else
                        {
                            char * tempHexed;
                            unsigned char * crypted;
                            crypted = client->clientCipher->encipher((unsigned char *) thisHost->getPassword()->latin1(),(int) thisHost->getPassword()->length());
                            tempHexed = hexer->b10to16(crypted,
                                client->clientCipher->padLength(thisHost->getPassword()->length()));
                            outPut << tabs(depth) << "\tpassword \"" << (char *) tempHexed << "\";" << endl;
                            delete crypted;
                            delete tempHexed;
                        }
                    }
                    moduleList * thisModule = thisHost->getFirstModule();
                    while (thisModule != NULL)
                    {
                        outPut << tabs(depth) << "\tmodule \"" << thisModule->getModule()->getName()->data() << "\";" << endl;
                        thisModule = thisModule->getNextModule();
                    }
                    outPut << tabs(depth) << "};" << endl;              
                    thisHost = thisHost->getNext();
                }        
            } /* finished writing out hosts for this group */
        
            /* now close out this group's block */
            depth--;
            outPut << tabs(depth) << "};" << endl;
            
            if (thisGroup->getNext() != NULL) { thisGroup = thisGroup->getNext(); }
            else { thisGroup = thisGroup->getParentGroup(); depth--; justUp = true; }
        }
    }

    #ifdef DEBUG_WRITEHOSTSFILE
        debug("olympus::writeHostFile() -> end of function");
    #endif
    
    hosts->close();
	delete hosts; 
    delete hexer;
}
