/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   readOlympusFile.cc
*
*   Description:
*   Reads in $HOME/.olympus/olympus.conf
*
*****************************************************************************/

#include "olympus.h"
#include "des.h"
#include "cipher.h"
#include "regexx.hh"
#include "split.hh"

using namespace regexx;
// Debugging stuff...
//#define DEBUG_FILEIO
//#define DEBUG_FILEIO_CHECK
//#define DEBUG_CRYPTO            // don't enable for security reasons...

#include <qtextstream.h>

void olympus::readOlympusFile(QTextStream *inPut)
{
    #ifdef DEBUG
        debug("olympus::readOlympusFile() -> start of function");
    #endif

    //reset the initilization vector for the cipher
    clientCipher->resetIV();

    Regexx *rexx = new Regexx();
    QString *thisLine = new QString();
    QString *newKey = new QString();
    QString *newValue = new QString();
   
    // regular expressions
    // should make changing formats a little less painfull ;)
    const char *isKeyValue = "^([a-zA-Z0-9]+) \"([a-zA-Z0-9 _/\\.\\,]+)\";";
    const char *isEob = "^};";  // eob = end of block

    while ( !inPut->atEnd() )
    {
        thisLine->remove(0, -1);
        thisLine->append(inPut->readLine().simplifyWhiteSpace());

        if (rexx->exec(thisLine->data(), isKeyValue))
        {
            newKey->truncate(0);
            newValue->truncate(0);

            newKey->append(rexx->match[0].atom[0].str().c_str());

            if (Regexx(newKey->data(), "defaultUsername") || Regexx(newKey->data(), "defaultPassword"))
            {
                #ifdef DEBUG_CRYPTO
                    debug("nice crypto... %s", newKey->data());
                #endif

                cipher *hexer = new cipher();
                unsigned char * tempHexed = hexer->b16to10((char *) rexx->match[0].atom[1].str().c_str(), rexx->match[0].atom[1].length());
                int tempLength = clientCipher->decipher(tempHexed, rexx->match[0].atom[1].length() >> 1);
                unsigned char * temp = new unsigned char[tempLength + 1];

                memcpy(temp, tempHexed, tempLength);
                temp[tempLength] = '\0';
                newValue->append((char *) temp);

                #ifdef DEBUG_CRYPTO
                    debug("tempHexed: %s, newValue: %s", (char*)tempHexed, newValue->data());
                #endif

                if (prefs->find("defaultWeSavePassword") != NULL)
                {
                    prefs->replace("defaultWeSavePassword", new QString("TRUE"));
                    #ifdef DEBUG_FILEIO_CHECK
                        debug("defaultWeSavePassword found.");
                    #endif
                }               
                else
                {
                    prefs->insert("defaultWeSavePassword", new QString("TRUE"));
                    #ifdef DEBUG_FILEIO_CHECK
                        debug("defaultWeSavePassword wasnt found.");
                    #endif
                }
                // set the vaule here.
                delete[] temp;
                delete tempHexed;
		delete hexer;
            }
            else
            {
               #ifdef DEBUG_CRYPTO
                    debug("da. no crypto needed. just throw her in...");
                #endif
                newValue->append(rexx->match[0].atom[1].str().c_str());
            }

            if (prefs->find(*newKey) != NULL)
            {
                prefs->replace(*newKey, new QString(*newValue));
                #ifdef DEBUG_FILEIO_CHECK
                    debug("newKey is found.");
                #endif
            }               
            else
            {
                prefs->insert(*newKey, new QString(*newValue));
                #ifdef DEBUG_FILEIO_CHECK
                    debug("newKey wasnt found.");
                #endif
            }

            #ifdef DEBUG_FILEIO
                debug("newKey=%s", newKey->data());
                debug("newValue=%s", newValue->data());
            #endif
        }
        else if (rexx->exec(thisLine->data(), isEob))
        {
            #ifdef DEBUG_FILEIO
                debug("isEob.");
            #endif
            break;
        }
        else
        {
            rexx->str("");
            #ifdef DEBUG_FILEIO
                debug("Clearing rexx.");
            #endif
        }
    }

    #ifdef DEBUG_FILEIO_CHECK
        debug("\n----------------------------------\n");
        QDictIterator<QString> it( *prefs);
        while ( it.current() )
        {
            debug("%s=%s", it.currentKey().data(), it.current()->data());
            debug("\n----------------------------------\n");
            ++it;
        }
    #endif

    delete rexx;
    delete thisLine;
    delete newKey;
    delete newValue;

    #ifdef DEBUG
        debug("olympus::readOlympusFile() -> end of function");
    #endif
}
