/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    readHostsFile.cc
*
*    reads in a file in the standard format and loads the entries into the
*	 listview
*
*****************************************************************************/

#include "olympus.h"
#include "groupObj.h"
#include "hostObj.h"
#include "moduleList.h"
#include "regexx.hh"
#include "split.hh"
#include "des.h"
#include "cipher.h"
using namespace regexx;

#include <iostream>

#include <qfile.h>
#include <qtextstream.h>

// For debugging...
//#define DEBUG_READHOSTS
//#define DEBUG_READHOSTSDETAILS

void olympus::readHostsFile(QTextStream* inPut, groupObj* thisGroup = NULL)
{
	#ifdef DEBUG_READHOSTS
		debug("\nreadHostsFile >>  begining read of hosts file");
	#endif
	
    if (thisGroup == NULL) { thisGroup = hostRoot; 	clientCipher->resetIV();}
    
	cipher * hexer = new cipher();
	// reset the initialization vector in the cipher

	
	Regexx rexx;
	QString * thisLine = new QString();
	//  regular expressions for later use
	//  should make changing formats a little less painful
	const char * isgroup = "^group \"([a-zA-Z0-9 \\'\\:\\!\\\\\\^\\&\\%\\$\\#\\@\\(\\)\\-\\+\\=\\_\\.\\,\\<\\>\\/\\?\\~\\`]+)\" \\{";
	const char * ishost =  "^host \"([a-zA-Z0-9 \\'\\:\\!\\\\\\^\\&\\%\\$\\#\\@\\(\\)\\-\\+\\=\\_\\.\\,\\<\\>\\/\\?\\~\\`]+)\" \\{";
	const char * ishostname = "hostname \"([a-zA-Z0-9\\.]+)\";";
	const char * isport = "port \"([0-9]+)\";";
	const char * isusername = "username \"([a-zA-Z0-9]+)\";";
	const char * ispassword = "password \"(.+)\";";
	const char * ismodule = "module \"([a-zA-Z0-9 ]+)\";";
	const char * isEob = "^\\};"; // eob = end of block
	
	hostObj * newItem;
	while (! inPut->atEnd())
	{
		thisLine->remove(0,-1);
		thisLine->append(inPut->readLine().simplifyWhiteSpace());
		#ifdef DEBUG_READHOSTS
			debug("readHostsFile >>  \tread in:\t\t%s", thisLine->data());
		#endif
		
		rexx.str(""); // in case we get two things of the same name
		// process a group item
		if (rexx.exec(thisLine->data(),isgroup))
		{
			#ifdef DEBUG_READHOSTS
				debug("readHostsFile >>  \tfound a group item: < %s > which is < %i > bytes long, put it in group %s", rexx.match[0].atom[0].str().c_str(),rexx.match[0].atom[0].length(), thisGroup->getName()->data());
			#endif
			QString* newName = new QString(rexx.match[0].atom[0].str().c_str());
			readHostsFile(inPut,new groupObj(thisGroup, newName));
		    delete newName;
		} // process a host item
		else  if (rexx.exec(thisLine->data(), ishost))
		{
			bool virginModules = true;
						
			#ifdef DEBUG_READHOSTS
				debug("readHostsFile >>  \tfound a host item < %s >, putting it into group %s", rexx.match[0].atom[0].str().c_str(), thisGroup->getName()->data());
			#endif
			
    		newItem = new hostObj(thisGroup, false, (char*) rexx.match[0].atom[0].str().c_str());
			
			// get the details for the hostObj
			while (! inPut->atEnd() && ! rexx.exec(thisLine->data(), isEob))
			{
				thisLine->remove(0,-1);
				thisLine->append(inPut->readLine().simplifyWhiteSpace());
    			
    			#ifdef DEBUG_READHOSTSDETAILS
    				debug("readHostsFile >>  \treading hosts block < %s >", thisLine->data());
    			#endif
    			
   				rexx.str(""); // in case we get two mods of the same name

				if (rexx.exec(thisLine->data(), ishostname))
				{
        			#ifdef DEBUG_READHOSTSDETAILS
		        		debug("readHostsFile >>  \t\thostname: < %s >", rexx.match[0].atom[0].str().c_str());
        			#endif
					newItem->setHostname(rexx.match[0].atom[0].str().c_str());
				}
				else if (rexx.exec(thisLine->data(), isport))
				{
        			#ifdef DEBUG_READHOSTSDETAILS
		        		debug("readHostsFile >>  \t\tport: < %s >", rexx.match[0].atom[0].str().c_str());
        			#endif
					thisLine->remove(0,-1);
					thisLine->append(rexx.match[0].atom[0].str().c_str());
					newItem->setPort(thisLine->toUInt());
				}
				else if (rexx.exec(thisLine->data(), isusername))
				{
        			#ifdef DEBUG_READHOSTSDETAILS
		        		debug("readHostsFile >>  \t\tusername: < %s >", rexx.match[0].atom[0].str().c_str());
        			#endif
					unsigned char * tempHexed = hexer->b16to10((char *) rexx.match[0].atom[0].str().c_str(), rexx.match[0].atom[0].length());
					int tempLength = clientCipher->decipher(tempHexed, rexx.match[0].atom[0].length() >> 1);
                    unsigned char * username = new unsigned char[tempLength + 1];

                    memcpy(username, tempHexed, tempLength);
                    username[tempLength] = '\0';
                    
                    newItem->setUsername((char *) username);

                    delete username;
					delete tempHexed;
				}
				else if (rexx.exec(thisLine->data(), ispassword))
				{
        			#ifdef DEBUG_READHOSTSDETAILS
		        		debug("readHostsFile >>  \t\tpassword: < %s >", rexx.match[0].atom[0].str().c_str());
        			#endif
					unsigned char * tempHexed = hexer->b16to10((char *) rexx.match[0].atom[0].str().c_str(), rexx.match[0].atom[0].length());
					int tempLength = clientCipher->decipher(tempHexed, rexx.match[0].atom[0].length() >> 1);
                    unsigned char * password = new unsigned char[tempLength + 1];

                    memcpy(password, tempHexed, tempLength);
                    password[tempLength] = '\0';

					newItem->setPassword((char *) password);
					newItem->setPasswordSave(true);

                    delete password;
					delete tempHexed;
				}
				else if (rexx.exec(thisLine->data(), ismodule))
				{	
    	    		#ifdef DEBUG_READHOSTSDETAILS
        				debug("readHostsFile >>  \t\tmodule time! < %s >", thisLine->data());
    					debug(">>>>>>> we gots %s", rexx.match[0].atom[0].str().c_str());
        			#endif
					
					module * thisModule;
					moduleList * modListCurr;
					moduleList * tempModList;
					if (modules->find(rexx.match[0].atom[0].str().c_str()) != NULL)	
					{
						thisModule = modules->find(rexx.match[0].atom[0].str().c_str());
						// if its the first module loaded from the file, replace the defaults...
						if (virginModules)
						{
							modListCurr = newItem->getFirstModule();
							// go to the end of the list
							while (modListCurr->getNextModule()) 
							{
								modListCurr = modListCurr->getNextModule(); 
							}	
							// start deleting mods from the end of the list to the start of the list
							while (modListCurr)
							{
								tempModList = modListCurr;
								modListCurr = modListCurr->getPrevModule();
								delete tempModList;
							}
							//hammer the first one in the list if its  there
							if (modListCurr) { 
								delete modListCurr; 
							}
							newItem->clearFirstModule();
							virginModules = false;
						} // if(virginModules)
						
	    	    		#ifdef DEBUG_READHOSTSDETAILS
                            debug(">>>>>>> we gots %s %s", rexx.match[0].atom[0].str().c_str(), thisModule->getFilename()->data());
                        #endif
						newItem->addModule(thisModule);
					} // if(client->modules...
				} // else if this ismodule
 				else 
 				{
					rexx.str("");
				}
			} //  ends: while (! inPut->atEnd() && ! rexx.exec(thisLine->data(), isEob))
		} // ends: else if (rexx.exec(thisLine->data(), ishost))
		else if (rexx.exec(thisLine->data(), isEob))
		{
			return;
		}
		else 
		{
			rexx.str("");
		}
	} // while		
	
	delete thisLine;
	delete hexer;

	#ifdef DEBUG_READHOSTS
		debug("readHostsFile >>  finished read of hosts file");
		debug("");
	#endif
}

void olympus::readHostsFile()
{
    // read in the hosts file if it exists
    QString temp(*prefs->find("homePath") + hostsFileName);
    
    if (QFile::exists(temp))
    {
        QFile * hostsFile = new QFile(temp);
        if (hostsFile->size() > 0)
        {   
            hostsFile->open(IO_ReadOnly);
            QTextStream* inPut = new QTextStream(hostsFile);
            readHostsFile(inPut);
            delete inPut;
            hostsFile->close();
        }
        
        delete hostsFile;       
    }
    
    // set up a default item to get the user going if they have no hosts set up
	if (hostRoot->getFirstChild() == NULL) 
	{
        new hostObj(client->hostRoot, false, client->prefs->find("defaultCommonName"));
    }
}