/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   readDefaultModulesFile.cc
*
*   Description:
*   This function read's in defaultmodules.conf and inserts all
*   modules entries into the double linked list defaultModules.
*
*****************************************************************************/

#include "olympus.h"
#include "moduleList.h"
#include "module.h"
#include "regexx.hh"
#include "split.hh"

using namespace regexx;

#include <qfile.h>
#include <qtextstream.h>

// For debugging.
//#define DEBUG_FILEIO
//#define DEUBG_FILEIO_CHECK

void olympus::readDefaultModulesFile()
{
    #ifdef DEBUG
        debug("olympus::readDefaultModulesFile() -> start of function");
    #endif

    Regexx *rexx = new Regexx();
    QFile confFile(*prefs->find("homePath") + defaultModulesFileName);
    QString thisLine, newModule, newGroup, newVersion;
    QTextStream *inPut;

    if (confFile.exists() && confFile.open(IO_ReadOnly))
    {
        inPut = new QTextStream(&confFile);
    }
    else { return; }

    // regular expressions
    // should make changing formats a little less painfull ;)
    const char *isModule = "module \"([a-zA-Z0-9 ]+)\" \\{";
    const char *isGroup = "group \"([a-zA-Z0-9 _/\\.]+)\";";
    const char *isVersion = "version \"([a-zA-Z0-9 _/\\.]+)\";";
    const char *isEob = "^\\};";  // eob = end of block

    moduleList *tempModule = defaultModules;
    module *newModules;

    while (!inPut->atEnd())
    {
        thisLine.remove(0,-1);
        thisLine.append(inPut->readLine().simplifyWhiteSpace());

        // Check to see if it's a Module.
        if (rexx->exec(thisLine.data(), isModule))
        {
            newModule.truncate(0);
            newGroup.truncate(0);
            newVersion.truncate(0);

            newModule.append(rexx->match[0].atom[0].str().c_str());
            #ifdef DEBUG_FILEIO
                debug("newModule => %s", newModule.data());
            #endif

            while (!inPut->atEnd())
            {
                thisLine.remove(0,-1);
                thisLine.append(inPut->readLine().simplifyWhiteSpace());

                // Check to see if it's a group.
                if (rexx->exec(thisLine.data(), isGroup))
                {
                    newGroup.append(rexx->match[0].atom[0].str().c_str());
                    #ifdef DEBUG_FILEIO
                        debug("newGroup => %s", newGroup.data());
                    #endif
                }
                // Check to see if it's a version.
                else if (rexx->exec(thisLine.data(), isVersion))
                {
                    newVersion.append(rexx->match[0].atom[0].str().c_str());
                    #ifdef DEBUG_FILEIO
                        debug("newVersion => %s", newVersion.data());
                    #endif
                }
                // Check to see if it's a End of Block.
                else if (rexx->exec(thisLine.data(), isEob))
                {
                    #ifdef DEBUG_FILEIO
                        debug("\n----------------------------------\n");
                    #endif
                    break;
                }
                else
                {
                    rexx->str("");
                    #ifdef DEBUG_FILEIO
                        debug("Clearing rexx.."); 
                    #endif
                }
            }

            if ((newModules = modules->find(newModule)) > 0)
            {
                #ifdef DEBUG_FILEIO
                    debug("Found module: %s %s %s.", newModules->getName()->data(), newVersion.data(), newModules->getVersion()->data());
                #endif
                if (newVersion == *newModules->getVersion() && newGroup == *newModules->getGroup())
                {
                    #ifdef DEBUG_FILEIO
                        debug("Adding newModules to moduleList.");
                    #endif
                    new moduleList(newModules, NULL, tempModule);
                    tempModule = tempModule->getNextModule();
                    cout << "adding default module!" << endl;
                }
            }
            #ifdef DEBUG_FILEIO
                debug("Read Default Modules >>  getting next module");
            #endif
        }
        // Check to see if it's an Eob (End of block.)
        else if (rexx->exec(thisLine.data(), isEob))
        {
            #ifdef DEBUG_FILEIO
                debug("isEob..");
            #endif
            break;
        }
        else
        {
            #ifdef DEBUG_FILEIO
                debug("clearing rexx..."); 
            #endif
            rexx->str("");
        }
    }

    #ifdef DEBUG_FILEIO_CHECK
        debug("\n------------------\n");
        moduleList *w = defaultModules;
        while (w)
        {
            debug("w => %s", w->getModuleName()->data());
            w = w->getNextModule();
            debug("\n------------------\n");
        }
    #endif


    confFile.close();    
    delete rexx;
    
    #ifdef DEBUG
        debug("olympus::readDefaultModulesFile() -> end of function");
    #endif
}
