/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   olympus.cc
*
*   Description: 
*   Olympus's constructor and deconstructor... initiate's all defaults. 
*
*   it first sets up some defaults... then gets the user to log in...
*   then it reads the config files...
*
*****************************************************************************/

#include "olympus.h"
#include "module.h"
#include "moduleList.h"
#include "plugin.h"
#include "defs.h"
#include "groupObj.h"

#include <qdir.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qtextstream.h>

// For debugging...
//#define DEBUG_FILEIO_CHECK
//#define DEBUG_STARTUP_SCREEN
//#define DEBUG_MODULES
#include <qlistview.h>

olympus::olympus()
{
    #ifdef DEBUG
        debug("olympus::olympus() -> start of constructor");
    #endif
        
    QDir *testdir;
    QFile *confFile;
    
    clientCipher = NULL;
    
    this->hostsFileName.append("hosts");
    this->authFileName.append("auth");
    this->olympusFileName.append("olympus.conf");
    this->modulesFileName.append("modules.conf");
    this->defaultModulesFileName.append("defaultmodules.conf");
   
    QListView* temp = new QListView(0);
    QColor foregroundColor("black");
    QColor backgroundColor("white");
    QColorGroup colors( foregroundColor, 
                        temp->colorGroup().button(), 
                        temp->colorGroup().light(), 
                        temp->colorGroup().dark(), 
                        temp->colorGroup().mid(), 
                        foregroundColor, 
                        backgroundColor);
    
    listPalette = new QPalette(colors, colors, colors);
    delete temp;
    // initialize the dictionary for currently running modules
    this->midCounter = 0;
    this->openModules = new QDict<plugin>(9973, true);

    // set the path to the place we call home... *warm fuzzies*
    this->prefs = new QDict<QString>(9973, false);
    this->prefs->insert("homePath", new QString(QDir::homeDirPath()));
    this->prefs->find("homePath")->append("/.olympus/");
    this->prefs->insert("userModuleDir", new QString(*this->prefs->find("homePath") + "plugins/"));
    this->prefs->insert("modulePath", new QString(CLIENT_PLUGIN_PATH));
    this->prefs->insert("baseOlympusPath", new QString("/usr/local/olympus/"));
    this->prefs->insert("tmpDataPath", new QString(*this->prefs->find("homePath") + "temp/"));
    
    // start inserting things into the defaults for hostObjs...
    this->prefs->insert("defaultHostname", new QString("localhost"));
    this->prefs->insert("defaultCommonName", new QString("Local Computer"));
    this->prefs->insert("defaultPort", new QString("569"));
    this->prefs->insert("defaultWeSavePassword", new QString("FALSE"));

    this->username = NULL;
    this->password = NULL;

    testdir = new QDir(*prefs->find("homePath"));
    QFile * authfile =  new QFile(*prefs->find("homePath") + authFileName);
    if (! testdir->exists() || ! authfile->exists())
    {
        if (startupScreen())
        {
            testdir->mkdir(*prefs->find("homePath"));
            while (password == NULL)
            {
                #ifdef DEBUG 
                    debug("main -> logging in");
                #endif
                
                firstLoginScreen();
        
                #ifdef DEBUG 
                    debug("main -> logging in done? %i", password);
                #endif
                if ((password == NULL))
                {
                    QMessageBox::information(0,"Login Error", "The passwords supplied did not match each other.\nPlease try again.");
                }
            }        
        }
        else
        {
            exit(0);
        }
    }
    else
    {
        /* ok, so now the user logs in.. we hope */
        while ((username == NULL) || (password == NULL))
        {
            #ifdef DEBUG 
                debug("main -> logging in");
            #endif
            loginScreen();
    
            if ((username == NULL) || (password == NULL))
            {
                QMessageBox::critical(0,"Login Error", "The login information you provided is wrong, please try again");
            }
        }
    }
    delete authfile;
    delete testdir;
    
    // make the temp directory in the user's olympus dir
    testdir = new QDir(*prefs->find("tmpDataPath"));
    if (! testdir->exists())
    {
          testdir->mkdir(*prefs->find("tmpDataPath"));
    }
    delete testdir;

    // make the plugins directory in the user's olympus dir
    testdir = new QDir(*prefs->find("userModuleDir"));
    if (! testdir->exists())
    {
          testdir->mkdir(*prefs->find("userModuleDir"));
    }
    delete testdir;
    
    // Reading in of olympus.conf
    confFile = new QFile(*prefs->find("homePath") + olympusFileName);
    if (confFile->exists() && confFile->open(IO_ReadOnly))
    {
        QTextStream *olympusStream = new QTextStream(confFile);
        readOlympusFile(olympusStream);
        confFile->close();
        delete olympusStream;
    }
    delete confFile;
    
    baseOlympusPath = new string(this->prefs->find("baseOlympusPath")->data());
    tmpDataPath = new string(this->prefs->find("tmpDataPath")->data());

    // set up the module dictionary and add the admin mod
    this->modules = new QDict<module>(9973, true);
    this->modulesByName = new QDict<QString>(9973, true);

    loadModules();

    if (! modules->find("Olympus Admin")) 
    {
        modules->insert("Olympus Admin",new module( "mod_admin.so",
                                                    "mod_admin",
                                                    "Olympus Admin",
                                                    "Used to administrate an Olympus server",
                                                    "Olympus",
                                                    "Aaron J. Seigo, Mount Linux Devel Team, (c)2000 under the GPLv2",
                                                    "0.1")
                                                );
        modulesByName->insert("mod_admin.so",new QString("mod_admin"));
    }

    // Reading in of defaultmodules.conf
    this->defaultModules = new moduleList(modules->find("Olympus Admin"));
    
    readDefaultModulesFile();
    
    QString* rootName = new QString("Hosts");
    hostRoot = new groupObj(NULL, rootName);
    delete rootName;
    
    #ifdef DEBUG
        debug("olympus::olympus() -> end of constructor");
    #endif
}

olympus::~olympus()
{
    #ifdef DEBUG
        debug("olympus::~olympus() -> start of deconstructor");
    #endif
    QString *temp;
    QFile *olympusFile;

    // Writing out of olympus.conf
    temp = new QString(prefs->find("homePath")->data());
    temp->append(olympusFileName);

    olympusFile = new QFile(*temp);
    if(!olympusFile->open(IO_WriteOnly))
    {
        temp->prepend("Error loading configuration file:\n\n          ");
        temp->append("\n\nWill continue using defaults.\nPlease check file permissions.");
        QMessageBox::warning(0, "Error!", *temp);
    }
    else
    {        
        QTextStream *olympusStream = new QTextStream(olympusFile);
        writeOlympusFile(olympusStream);
        olympusFile->close();
        delete olympusStream;
    }
   
    // Writing out of defaultmodules.conf
    writeDefaultModulesFile();
    
    // Writing out of hosts
    saveHostsFile();
    
    #ifdef DEBUG
        debug("olympus::~olympus() -> end of deconstructor");
    #endif
}


void olympus::execHelp()
{ 
    if (!fork())
    {
        if (execl(OLYMPUS_BASE_PATH "/bin/olympushelp",NULL)==-1) 
        {
           exit(-1);
        }
    }
}

void olympus::die() { exit(1); }
