/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   makeTempFile.cc
*
*   Returns an open file handle to a temporary file and puts the file name
*   into the QString it is handed. This code was based on a snippet from 
*   common/netmessage/receive.cc
*
*   Returns 0 on failure.
*
*   Aaron J. Seigo  <aseigo@mountlinux.com>
*
*****************************************************************************/

#include "olympus.h"
#include <limits.h>

int olympus::makeTempFile(QString* tempFileName)
{
    char* filePath = new char[tmpDataPath->length() + 18];
    int filedesc;
    
    strncpy(filePath, tmpDataPath->c_str(), tmpDataPath->length() + 1);
    strncat(filePath, "olympustmp.XXXXXX", 17);
    filePath[tmpDataPath->length() + 17] = '\0';
    
    if (tmpDataPath->length() + 18 < PATH_MAX && 
        (filedesc = mkstemp(filePath)) >= 0)
    {
        tempFileName->truncate(0);
        tempFileName->append(filePath);
        delete[] filePath;
        return filedesc;
    }
    else
    {
        delete[] filePath;
        return 0;
    }
}