/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   main.cc
*
*   Description:
*   This holds the main function of Olympus...
*   This is where we create the application and show it to the user...
*
*****************************************************************************/

#include "config.h"
#include "defs.h"
#include "olympus.h"
#include "mainWindow.h"
#include "icons.h"
#include "random.h"
#include "version.h"

#include <fcntl.h>   
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

// ICCCM stuff
#ifndef _WINDOWS
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif

#include <qapplication.h>
#include <qcdestyle.h>
#include <qpixmap.h>

icons * icon_small;
icons * icon_large;

olympus* client;
string* baseOlympusPath;
string* tmpDataPath;

/* random number generator */
CSPRNG *RNG = new CSPRNG;

int main( int argc, char* argv[] )
{
    #ifdef DEBUG 
        // open up logging to trace program activity/crashes...
        // this is only for the beta/development cycles... 
        dup2(open("/tmp/olympus_client.log",O_WRONLY | O_CREAT | O_TRUNC,0664),2);
        dup2(2,1);
      
        debug("main -> start of main function");
    #endif

    QApplication app(argc, argv);

    /* after a vote on the mailing list on June 2nd, 2000 it was decided that CDE 
       would be the default style. - Aaron J. Seigo */
    app.setStyle( new QCDEStyle );

    icon_small = new icons("small");
    icon_large = new icons("large");
    client = new olympus();
    client->readHostsFile();
    
    QObject::connect(&app, SIGNAL(aboutToQuit()),client,SLOT(lastChanceClean()));

    mainWindow *mainwindow = new mainWindow();
    app.setMainWidget(mainwindow);
    mainwindow->setCaption( "Olympus Client v" VERSION_OLYMPUS);

    // thx to the rednecks on this one... 
    // followed this thread on their mailing list and "borrowed" the
    // resulting code =)
    // ICCCM standard stuff that Qt does not bother with
    #ifndef _WINDOWS
        XWMHints hints;
        XClassHint classhints;
        Display * d = mainwindow->x11Display();
        Window w = mainwindow->handle();
 
        XSetCommand(d,w,argv,argc);
        XSetIconName(d,w,"Olympus");
        hints.flags = WindowGroupHint | IconPixmapHint;
        hints.window_group = mainwindow->handle();
        hints.icon_pixmap = icon_small->find("olympus")->handle();
 
        classhints.res_name = "olympus";
        classhints.res_class = "Olympus";
	
        XSetWMProperties( d, w, 0, 0, 0, 0, 0, &hints, &classhints );
    #endif // end of ICCCM stuff

    mainwindow->resize(550,450);
    mainwindow->show();

    int returnValue = app.exec();

    delete mainwindow;
    delete client;
    delete icon_small;
    delete icon_large;

    #ifdef DEBUG
        debug("main -> end of main function returnValue = %i", returnValue);
    #endif

    return returnValue;
}
