/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   loginScreen.h 
*
*   This is the window you see when you are typing in your username and 
*   password to get into Olympus when it is first started
*
*****************************************************************************/

#include "olympus.h"
#include "../icons/mountlinuxsmall.xpm"

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpixmap.h>
#include <qpushbutton.h>

//#define DEBUG_LOGINSCREEN

void olympus::loginScreen()
{
    #ifdef DEBUG_LOGINSCREEN
        debug("\nLogin Screen >>  Login window building...");
    #endif

    // splash screen / login window
    QDialog *splashScreen = new QDialog(0,"Mount Linux Olympus",true);

    QPixmap logo(mountlinuxsmall_xpm);

    QLabel *logoBox = new QLabel(splashScreen, "ModuleLogoBox");
    logoBox->setGeometry(20, 20, 310, 63);
    logoBox->setMinimumSize(0, 0);
    logoBox->setMaximumSize(32767, 32767);
    logoBox->setFrameStyle(QFrame::Box | QFrame::Sunken);
    logoBox->setLineWidth(2);
    logoBox->setBackgroundPixmap(logo);
    logoBox->setFixedSize(logo.size());       

    QLabel *loginLabel = new QLabel("<b>Log In To Olympus</b>", splashScreen, "loginLabel");
    loginLabel->setAlignment(QLabel::AlignCenter | QLabel::ExpandTabs);
    loginLabel->setTextFormat(QLabel::RichText);
    loginLabel->setAutoResize(true);

    QLabel *explainLabel = new QLabel("<font size=3>This login is used to secure your remote login username and password information.</font>", splashScreen, "explainLabel");
    explainLabel->setAlignment(QLabel::AlignLeft | QLabel::AlignTop | QLabel::ExpandTabs | QLabel::WordBreak);
    explainLabel->setAutoResize(true);
    explainLabel->setFrameStyle(QFrame::Box | QFrame::Sunken);
    
    logoBox->setLineWidth(1);
    logoBox->setMargin(4);

    QFrame *hbar = new QFrame(splashScreen,"hbar");
    hbar->setFrameStyle(QFrame::HLine | QFrame::Sunken);

    QLabel *loginUsernameLabel = new QLabel(splashScreen,"loginUsernameLabel");
    loginUsernameLabel->setText("Username:");
    loginUsername = new QLineEdit(splashScreen,"password");

    QLabel *loginPasswordLabel = new QLabel(splashScreen,"loginPasswordLabel");
    loginPasswordLabel->setText("Password:");
    loginPassword = new QLineEdit(splashScreen,"password");
    loginPassword->setEchoMode(QLineEdit::Password);
    loginPasswordLabel->setFixedSize(loginPasswordLabel->sizeHint());

    QPushButton* loginButton = new QPushButton(splashScreen,"loginButton");
    loginButton->setText("Login...");
    
    QPushButton *exitButton = new QPushButton(splashScreen,"exitButton");
    exitButton->setText("Exit");
    
    #ifdef DEBUG_LOGINSCREEN
        debug("Login Screen >>  Login window pieces built... connecting to slots");
    #endif

    #ifdef DEBUG_LOGINSCREEN
        debug("Login Screen >>  Laying out login window");
    #endif

    QGridLayout *splashStuff = new QGridLayout(splashScreen,0,0,0,0,"splashLaout");
    splashStuff->addColSpacing(0,10);
    splashStuff->addColSpacing(2,8);
    splashStuff->addColSpacing(4,8);
    splashStuff->addColSpacing(6,10);
    splashStuff->addRowSpacing(0,64);
    splashStuff->addMultiCellWidget (logoBox, 0, 0, 0, 6, 0);
    splashStuff->addRowSpacing(1,20);
    splashStuff->addMultiCellWidget(loginLabel, 1, 1, 1, 6, 0);
    splashStuff->addRowSpacing(2,10);
    splashStuff->addWidget(loginUsernameLabel,3,1);
    splashStuff->addWidget(loginUsername,3,3);
    splashStuff->addWidget(exitButton,3,5);
    splashStuff->addWidget(loginPasswordLabel,4,1);
    splashStuff->addWidget(loginPassword,4,3);
    splashStuff->addWidget(loginButton,4,5);
    splashStuff->addRowSpacing(5,20);
    splashStuff->addMultiCellWidget(hbar, 5, 5, 1, 5, 0);
    splashStuff->addRowSpacing(6,explainLabel->minimumSizeHint().height());
    splashStuff->addMultiCellWidget(explainLabel, 6, 6, 1, 5, 0);
    splashStuff->addRowSpacing(7,5);

    /*  set the size of the window... 
        too bad setFixedSize doesn't work as advertised */
    splashScreen->setFixedSize(logo.size().width() + 2,splashStuff->sizeHint().height());
 
    // connect the lineEdit loginPassword and the pushButton loginButton
    // to the accept() of the dialog and the mainWindow slot that stores the
    // password value entered
    QObject::connect(loginPassword, SIGNAL(returnPressed()), splashScreen, SLOT(accept()));
    QObject::connect(loginPassword, SIGNAL(returnPressed()), this, SLOT(authLogin()));
    QObject::connect(loginButton, SIGNAL(clicked()), splashScreen, SLOT(accept()));
    QObject::connect(loginButton, SIGNAL(clicked()), this, SLOT(authLogin()));
    QObject::connect(exitButton, SIGNAL(clicked()), this, SLOT(die()));

    loginUsername->setFocus();

    #ifdef DEBUG_LOGINSCREEN
        debug("Login Screen >>  About to show");
    #endif
 
    splashScreen->exec();
    
    if (splashScreen->result() == QDialog::Rejected) { die(); }
    
    #ifdef DEBUG_LOGINSCREEN
        debug("Login Screen >>  Login window finished\n");
    #endif
}
