/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   loadNewModules.cc
*
*   Description: 
*   Loads all module files in the plugin directory that isn't currently  
*   listed in the modules directory.
*
*****************************************************************************/

#include "plugin.h"
#include "moduleList.h"
#include "module.h"
#include "regexx.hh"

using namespace regexx;

#include <qdir.h>

//#define DEBUG_LOADNEWMODS

void olympus::loadModules()
{
    #ifdef DEBUG_LOADNEWMODS
        debug("\nLoading New Modules >>  attempting to load any new modules");  
    #endif

    Regexx *rexx = new Regexx();
    QString fullpath;
    QString modName;
    QString thisFileName;
    plugin *newPlug = NULL;
    int i = 0;
 
    #ifdef DEBUG_LOADNEWMODS
        debug("Loading New Modules >>  modulePath = %s", prefs->find("modulePath")->data());
    #endif
    
    QString* moduleDirPath = prefs->find("modulePath");
    QDir moduleDir(*moduleDirPath);     
    moduleDir.setFilter(QDir::Readable | QDir::Files);
    QStringList moduleList(moduleDir.entryList("mod_*.so"));
    QStringList::Iterator modIterator = moduleList.begin();
    int numModules = moduleList.count();
    
    QString* userModuleDirPath = prefs->find("userModuleDir");
    QDir userModuleDir(*userModuleDirPath);
    userModuleDir.setFilter(QDir::Readable | QDir::Files);
    QStringList userModuleList(userModuleDir.entryList("mod_*.so"));
    QStringList::Iterator userModIterator = userModuleList.begin();
    int numUserModules = userModuleList.count();
    
    // clear the current lists.
    modules->clear();
    modulesByName->clear();
    
    // add the modules in the user's plugin directory
    for (i = 0; i < numUserModules; i++, userModIterator++)
    {
        #ifdef DEBUG_LOADNEWMODS
        debug("Loading New Modules >>  file: %s", (*userModIterator).data()); 
        #endif
        thisFileName.truncate(0);
        thisFileName.append((*userModIterator));        
        
        if (rexx->exec(thisFileName.data(), "(mod_.+)\\.so"))
        {
            modName.truncate(0);
            modName.append(rexx->match[0].atom[0].str().c_str());
        }
        else { continue; }
        
        fullpath.truncate(0);
        fullpath.append(*userModuleDirPath);
        fullpath.append(thisFileName);    

        // if we don't find this mod in the listed already 
        // we go ahead and try to add it
        if (! modulesByName->find(thisFileName))
        {
            #ifdef DEBUG_LOADNEWMODS
                debug("Loading New Modules >>  module name: %s (%s)", fullpath.data(), modName.data());         
            #endif
            // if we get an instance of it...
            if ((newPlug = New<plugin>(modName.data())) > 0)
            {
                #ifdef DEBUG_LOADNEWMODS
                    debug("Loading New Modules >>  Found new module %s", modName.data());
                #endif

                modules->insert(newPlug->name(), new module((char*) thisFileName.data(),
                                                            (char*) modName.data(),
                                                            newPlug->name(),
                                                            newPlug->desc(),
                                                            newPlug->group(),
                                                            newPlug->credits(),
                                                            newPlug->version()
                                                            )
                                                           );
                modulesByName->insert(thisFileName,new QString(newPlug->name()));
                delete newPlug;
            }
            else if (DLC_Server.load(fullpath.data()) && (newPlug = New<plugin>(modName.data())) > 0)
            {   // if we didn't get an instance, we try an load it
                #ifdef DEBUG_LOADNEWMODS
                    debug("Loading New Modules >>  Loaded & Found new module %s", modName.data());
                #endif
                modules->insert(newPlug->name(), new module((char*) thisFileName.data(),
                                                            (char*) modName.data(),
                                                            newPlug->name(), 
                                                            newPlug->desc(),
                                                            newPlug->group(),
                                                            newPlug->credits(),
                                                            newPlug->version()
                                                            )
                                                           );
                modulesByName->insert(thisFileName,new QString(newPlug->name()));
                delete newPlug;
            }
        }
    }
    
    // now add the modules in the system wide plugin directory
    for (i = 0; i < numModules; i++, modIterator++)
    {
        #ifdef DEBUG_LOADNEWMODS
        debug("Loading New Modules >>  file: %s", (*modIterator).data()); 
        #endif
        thisFileName.truncate(0);
        thisFileName.append((*modIterator));        
        
        if (rexx->exec(thisFileName.data(), "(mod_.+)\\.so"))
        {
            modName.truncate(0);
            modName.append(rexx->match[0].atom[0].str().c_str());
        }
        else { continue; }
        
        fullpath.truncate(0);
        fullpath.append(*moduleDirPath);
        fullpath.append(thisFileName);    

        // if we don't find this mod in the listed already 
        // we go ahead and try to add it
        if (! modulesByName->find(thisFileName))
        {
            #ifdef DEBUG_LOADNEWMODS
                debug("Loading New Modules >>  module name: %s (%s)", fullpath.data(), modName.data());         
            #endif
            // if we get an instance of it...
            if ((newPlug = New<plugin>(modName.data())) > 0)
            {
                #ifdef DEBUG_LOADNEWMODS
                    debug("Loading New Modules >>  Found new module %s", modName.data());
                #endif

                modules->insert(newPlug->name(), new module((char*) thisFileName.data(),
                                                            (char*) modName.data(),
                                                            newPlug->name(),
                                                            newPlug->desc(),
                                                            newPlug->group(),
                                                            newPlug->credits(),
                                                            newPlug->version()
                                                            )
                                                           );
                modulesByName->insert(thisFileName,new QString(newPlug->name()));
                delete newPlug;
            }
            else if (DLC_Server.load(fullpath.data()) && (newPlug = New<plugin>(modName.data())) > 0)
            {   // if we didn't get an instance, we try an load it
                #ifdef DEBUG_LOADNEWMODS
                    debug("Loading New Modules >>  Loaded & Found new module %s", modName.data());
                #endif
                modules->insert(newPlug->name(), new module((char*) thisFileName.data(),
                                                            (char*) modName.data(),
                                                            newPlug->name(), 
                                                            newPlug->desc(),
                                                            newPlug->group(),
                                                            newPlug->credits(),
                                                            newPlug->version()
                                                            )
                                                           );
                modulesByName->insert(thisFileName,new QString(newPlug->name()));
                delete newPlug;
            }
        }
    }

    delete rexx;

    #ifdef DEBUG_LOADNEWMODS
        debug("Loading New Modules >>  finished loading new modules\n");
    #endif
}
