/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   launchModule.cc 
*   
*   Description:
*   used to launch plugins... 
*
*****************************************************************************/

#include "olympus.h"
#include "moduleList.h"
#include "module.h"
#include "plugin.h"
#include <string>
//#define DEBUG_LAUNCHMODULE

bool olympus::launchModule(moduleList *modRecord, hostObj *targetHost)
{
    QString stringMID;
    plugin *newPlug = NULL;
    
    #ifdef DEBUG_LAUNCHMODULE
        debug("\nLanching Module >>  Launching module...");
    #endif

    /*  a sanity check to see if it is already open
        eventually, we'll want to put the ability to bring the window into focus */
    if (modRecord->open)
    {
        #ifdef DEBUG_LAUNCHMODULE
            debug(">>>>>>>> STILL OPEN <<<<<<<<<<<");
        #endif
        stringMID.setNum(modRecord->mid);
        if ((newPlug = openModules->find(stringMID)) > 0)
        {
            newPlug->getFocus();
        }
        
        return false;
    }
  
    /*  NOTE: newPlug does not need deletion in this block.
        it gets passed on and handled elsewhere,
        specifically by the hostObj that it "belongs" to */
    module *modToLaunch = modRecord->getModule();
    unsigned int thisMID = ++midCounter; // get a new module ID
    QString className;
    QString filename;

    #ifdef DEBUG_LAUNCHMODULE
        debug("Lanching Module >>  Module to launch: %s", modToLaunch->getFilename()->latin1());
    #endif

    // turn this MID into a string for QDict
    stringMID.setNum(thisMID,10);
 
    // set the flags in the module list item
    modRecord->open = true;
    modRecord->mid = thisMID;
    
    // put the filename and classname together
    filename += *client->prefs->find("modulePath") + *modToLaunch->getFilename();
    className += *modToLaunch->getClassname();

    #ifdef DEBUG_LAUNCHMODULE
    debug("openning: %s",filename.latin1());
    #endif

    // the plugin has been loaded from file, so instantiate
    if ((newPlug = New<plugin>(className.latin1())) > 0)
    {
        #ifdef DEBUG_LAUNCHMODULE
            debug("Lanching Module >>  Trying to instatiate %s", className.latin1());
        #endif
        openModules->insert(stringMID,newPlug);
        openModules->find(stringMID)->exec(targetHost,thisMID, modRecord);
    }
    else // if the plugin isn't loaded from file, load then instatiate
    {
        #ifdef DEBUG_LAUNCHMODULE
            debug("Lanching Module >>  Couldn't instantiate, trying to load from file %s as %s", filename.latin1(), className.latin1());
        #endif
        DLC_Server.load(filename.latin1()); 
        if ((newPlug = New<plugin>(className.latin1())) > 0)
        {
            #ifdef DEBUG_LAUNCHMODULE
                debug("Lanching Module >>  Trying to instatiate %s", className.latin1());
            #endif
            openModules->insert(stringMID,newPlug);
            openModules->find(stringMID)->exec(targetHost,thisMID, modRecord);
        }
        else // total failure
        {
            // set the flags in the module list item
            modRecord->open = false;
            modRecord->mid = 0;
            return false; // failure
        }
    }
    return true;  // success
  
    #ifdef DEBUG_LAUNCHMODULE
        debug("Lanching Module >>  Launching module...\n");
    #endif
}
