/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   deleteModule.cc 
*
*   Description:
*   used to launch plugins... 
*
*****************************************************************************/

#include "olympus.h"
#include "des.h"
#include "cipher.h"

#include <qfile.h>

// #define DEBUG_CLEANUP

void olympus::lastChanceClean()
{
    #ifdef DEBUG_CLEANUP
        debug("\nOlympus Core >>  lastChanceClean >> everybody was kung-foo fighting");
    #endif

    if (clientCipher != NULL) { delete clientCipher; }
    clientCipher = new TripleDES((unsigned char *) password->data(),(int) password->length(),(unsigned char *) password->data(), (int) password->length());

    QFile * authfile =  new QFile(*prefs->find("homePath") + authFileName);

    if (authfile->open(IO_WriteOnly))
    {
        cipher * hexer = new cipher();
        unsigned char * tempCrypted = clientCipher->encipher((unsigned char *)username->data(), (int)username->length());
        char * tempHexed = hexer->b10to16(tempCrypted, clientCipher->padLength(username->length()));
        QString * authCrypt = new QString(tempHexed);

        authfile->open(IO_WriteOnly);
        authfile->writeBlock(authCrypt->data(),authCrypt->length());
        authfile->close();

        #ifdef DEBUG_CLEANUP
            debug("Olympus Core >>  lastChanceClean >> the following crypt text is %i bytes long: %s", (int) clientCipher->padLength(username->length()), authCrypt->data());
        #endif

        #ifdef DEBUG_CLEANUP
            debug("Olympus Core >>  lastChanceClean >> cleaning up\n");
        #endif

        delete tempCrypted;
        delete tempHexed;
        delete authCrypt;
        delete hexer;
    }
}
