/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   firstLoginScreen.h 
*
*   This is the window you see when you are typing in your username and 
*   password to get into Olympus when it is first started, the first time
*
*****************************************************************************/

#include "olympus.h"
#include <qpixmap.h>
#include <qapplication.h>
#include "../icons/mountlinuxsmall.xpm"

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>

//#define DEBUG_LOGINSCREEN

void olympus::firstLoginScreen()
{
    #ifdef DEBUG_LOGINSCREEN
        debug("\nLogin Screen >>  Login window building...");
    #endif

    // splash screen / login window
    QDialog *splashScreen = new QDialog(0,"Mount Linux Olympus",true);

    QPixmap logo(mountlinuxsmall_xpm);

    QLabel *logoBox = new QLabel(splashScreen, "ModuleLogoBox");
    logoBox->setGeometry(20, 20, 310, 63);
    logoBox->setMinimumSize(0, 0);
    logoBox->setMaximumSize(32767, 32767);
    logoBox->setFrameStyle(QFrame::Box | QFrame::Sunken);
    logoBox->setLineWidth(2);
    logoBox->setBackgroundPixmap(logo);
    logoBox->setFixedSize(logo.size());       

    QLabel *loginLabel = new QLabel("<b>Initial Log In To Olympus</b>", splashScreen, "loginLabel");
    loginLabel->setAlignment(QLabel::AlignCenter | QLabel::ExpandTabs);
    loginLabel->setTextFormat(QLabel::RichText);
    loginLabel->setAutoResize(true);

    QLabel *explainLabel = new QLabel("<font size=3>This login is used to secure your remote login username and password information.\n\nRemember this information as it is EXTREMELY important.</font>", splashScreen, "explainLabel");
    explainLabel->setAlignment(QLabel::AlignLeft | QLabel::AlignTop | QLabel::ExpandTabs | QLabel::WordBreak);
    explainLabel->setAutoResize(true);
    explainLabel->setFrameStyle(QFrame::Box | QFrame::Sunken);
    logoBox->setLineWidth(1);
    logoBox->setMargin(4);

    QFrame *hbar = new QFrame(splashScreen,"hbar");
    hbar->setFrameStyle(QFrame::HLine | QFrame::Sunken);

    QLabel *loginUsernameLabel = new QLabel(splashScreen,"loginUsernameLabel");
    loginUsernameLabel->setText("Username:");
    loginUsername = new QLineEdit(splashScreen,"password");
    if (username != NULL)
    {
        loginUsername->setText(*username);
    }

    QLabel *loginPasswordLabel = new QLabel(splashScreen,"loginPasswordLabel");
    loginPasswordLabel->setText("Password:");
    loginPassword = new QLineEdit(splashScreen,"password");
    loginPassword->setEchoMode(QLineEdit::Password);
    loginPasswordLabel->setFixedSize(loginPasswordLabel->sizeHint());

    QLabel *loginPasswordLabel2 = new QLabel(splashScreen,"loginPasswordLabel");
    loginPasswordLabel2->setText("Confirm:");
    loginPassword2 = new QLineEdit(splashScreen,"password2");
    loginPassword2->setEchoMode(QLineEdit::Password);
    loginPasswordLabel2->setFixedSize(loginPasswordLabel->sizeHint());
    
    QPushButton *loginButton = new QPushButton(splashScreen,"loginButton");
    loginButton->setText("Login...");
    
    QPushButton *exitButton = new QPushButton(splashScreen,"exitButton");
    exitButton->setText("Exit");

    QGridLayout *splashStuff = new QGridLayout(splashScreen,0,0,0,0,"splashLaout");
    splashStuff->addColSpacing(0,10);
    splashStuff->addColSpacing(2,8);
    splashStuff->addColSpacing(4,8);
    splashStuff->addColSpacing(6,10);
    splashStuff->addRowSpacing(0,64);
    splashStuff->addMultiCellWidget (logoBox, 0, 0, 0, 6, 0);
    splashStuff->addRowSpacing(1,20);
    splashStuff->addMultiCellWidget(loginLabel, 1, 1, 1, 6, 0);
    splashStuff->addRowSpacing(2,10);
    splashStuff->addWidget(loginUsernameLabel,3,1);
    splashStuff->addWidget(loginUsername,3,3);
    splashStuff->addRowSpacing(4,5);
    splashStuff->addWidget(loginPasswordLabel,5,1);
    splashStuff->addWidget(loginPassword,5,3);
    splashStuff->addWidget(exitButton,5,5);
    splashStuff->addWidget(loginPasswordLabel2,6,1);
    splashStuff->addWidget(loginPassword2,6,3);
    splashStuff->addWidget(loginButton,6,5);
    splashStuff->addRowSpacing(7,20);
    splashStuff->addMultiCellWidget(hbar, 7, 7, 1, 5, 0);
    splashStuff->addRowSpacing(8,explainLabel->minimumSizeHint().height());
    splashStuff->addMultiCellWidget(explainLabel, 8, 8, 1, 5, 0);
    splashStuff->addRowSpacing(9,5);

    /*  set the size of the window... 
        too bad setFixedSize doesn't work as advertised */
    splashScreen->setFixedSize(logo.size().width() + 2,splashStuff->sizeHint().height());
 
    // connect the lineEdit loginPassword and the pushButton loginButton
    // to the accept() of the dialog and the mainWindow slot that stores the
    // password value entered
    QObject::connect(loginPassword2, SIGNAL(returnPressed()), splashScreen, SLOT(accept()));
    QObject::connect(loginPassword2, SIGNAL(returnPressed()), this, SLOT(firstAuthLogin()));
    QObject::connect(loginButton, SIGNAL(clicked()), splashScreen, SLOT(accept()));
    QObject::connect(loginButton, SIGNAL(clicked()), this, SLOT(firstAuthLogin()));
    QObject::connect(exitButton, SIGNAL(clicked()), this, SLOT(die()));

    loginUsername->setFocus();

    #ifdef DEBUG_LOGINSCREEN
        debug("Login Screen >>  About to show");
    #endif
 
    splashScreen->exec();
    
    if (splashScreen->result() == QDialog::Rejected) { die(); }
    
    #ifdef DEBUG_LOGINSCREEN
        debug("Login Screen >>  Login window finished\n");
    #endif
}
