/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   authLogin
*
*   Takes loginPassword and loginUsername from the olympus class and 
*   updates the username, password and the auth file in .olympus/
*
*****************************************************************************/

#include "olympus.h"
#include "des.h"
#include "cipher.h"

//#define DEBUG_AUTHLOGIN
//#define DEBUG_AUTHLOGIN_CRYPTO    // Enabling logs sensitive information!!!

#include <qfile.h>
#include <qlineedit.h>

void olympus::firstAuthLogin() 
{
    #ifdef DEBUG_AUTHLOGIN
        debug("\nOlympus Core >>  authLogin >>  starting login authorization with %s and %s to check", loginPassword->text().latin1(), loginPassword2->text().latin1());
    #endif

    if (username == NULL) { delete username; }
    username = new QString();
    
    if (password != NULL) { delete password; }
    password = new QString();



    if (loginUsername->text().isNull() || loginPassword->text() != loginPassword2->text().latin1())
    {
        #ifdef DEBUG_AUTHLOGIN
            debug("Olympus Core >>  authLogin >> login ** UNSUCCESSFUL **, passwords do not match");
        #endif	
        delete password;
        password = NULL;
    }
    else
    {
        #ifdef DEBUG_AUTHLOGIN
            debug("Olympus Core >>  authLogin >>  engaging encryption");
        #endif
        setPassword();
        
        TripleDES * crypto = new TripleDES((unsigned char *) password->data(),(int) password->length(),(unsigned char *) password->data(), (int) password->length());
        cipher * hexer = new cipher();

        // we need some error checking on this file open here... :/
        QFile * authfile =  new QFile(*prefs->find("homePath") + authFileName);
        
        unsigned char * tempCrypted = crypto->encipher((unsigned char *)username->data(), (int)username->length());
        char * tempHexed = hexer->b10to16(tempCrypted, crypto->padLength(username->length()));
        QString * authCrypt = new QString(tempHexed);

        authfile->open(IO_WriteOnly);
        authfile->writeBlock(authCrypt->data(),authCrypt->length());
        authfile->close();
        
        delete crypto;
        delete hexer;
        delete tempCrypted;
        delete tempHexed;
        delete authCrypt;
    }
     
    #ifdef DEBUG_AUTHLOGIN
        debug("Olympus Core >>  authLogin >>  finished login authorization\n");
    #endif

}
