/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   authLogin
*
*   Takes loginPassword and loginUsername from the olympus class and 
*   updates the username, password and the auth file in .olympus/
*
*****************************************************************************/

#include "olympus.h"
#include "des.h"
#include "cipher.h"

//#define DEBUG_AUTHLOGIN
//#define DEBUG_AUTHLOGIN_CRYPTO    // Enabling logs sensitive information!!!

#include <qfile.h>


void olympus::authLogin() 
{
    #ifdef DEBUG_AUTHLOGIN
        debug("\nOlympus Core >>  authLogin >>  starting login authorization");
    #endif

    if (username != NULL) { delete username; }
    if (password != NULL) { delete password; }
    username = new QString();
    password = new QString();

    setPassword();

    #ifdef DEBUG_AUTHLOGIN
        debug("Olympus Core >>  authLogin >>  engaging encryption");
    #endif

    TripleDES * crypto = new TripleDES((unsigned char *) password->data(),(int) password->length(),(unsigned char *) password->data(), (int) password->length());

    QString * prevCrypt = new QString();
    cipher * hexer = new cipher();

    // we need some error checking on this file open here... :/
    QFile * authfile =  new QFile(*prefs->find("homePath") + authFileName);

    #ifdef DEBUG_AUTHLOGIN
        debug("Olympus Core >>  authLogin >> checking against current auth file %s: ", authfile->name().data());
    #endif

    if (authfile->exists())
    {
        int thisChar = 0;

        authfile->open(IO_ReadOnly);
        while ((thisChar = authfile->getch()) >= 0)
        {
            prevCrypt->append((char)thisChar);
        }

        #ifdef DEBUG_AUTHLOGIN_CRYPTO
            debug("Olympus Core >>  authLogin >> auth file says: %s", prevCrypt->data());
        #endif

        int strLength = prevCrypt->length();
        char testCrypt[strLength];
        strncpy(testCrypt,prevCrypt->data(),strLength);
        unsigned char * tempHexed = hexer->b16to10(testCrypt, strLength);
        int tempLength = crypto->decipher(tempHexed, strLength >> 1);
        unsigned char * temp = new unsigned char[tempLength + 1];

        prevCrypt->truncate(0);
        memcpy(temp, tempHexed, tempLength);
        temp[tempLength] = '\0';
        prevCrypt->append((char *) tempHexed);
        prevCrypt->truncate(tempLength);

        #ifdef DEBUG_AUTHLOGIN_CRYPTO
            debug("Olympus Core >>  authLogin >> decrypted it is: %s.. will compare to: %s..", prevCrypt->data(),username->data());
        #endif

        authfile->close();

        delete[] temp;
        delete tempHexed;
    }
    else
    {
	#ifdef DEBUG_AUTHLOGIN_CRYPTO
	        debug("prevcrypt is currently: %s", prevCrypt->data());
        #endif
	prevCrypt->append(*username);
    }

    if (*prevCrypt == *username) 
    { 
        #ifdef DEBUG_AUTHLOGIN_CRYPTO
            debug("Olympus Core >>  authLogin >> writing to file: %s", authfile->name().data());
        #endif
        crypto->resetIV();

        unsigned char * tempCrypted = crypto->encipher((unsigned char *)username->data(), (int)username->length());
        char * tempHexed = hexer->b10to16(tempCrypted, crypto->padLength(username->length()));
        QString * authCrypt = new QString(tempHexed);

        authfile->open(IO_WriteOnly);
        authfile->writeBlock(authCrypt->data(),authCrypt->length());
        authfile->close();

        #ifdef DEBUG_AUTHLOGIN_CRYPTO
            debug("Olympus Core >>  authLogin >> the following crypt text is %i bytes long: %s", (int) crypto->padLength(username->length()), authCrypt->data());
        #endif

        #ifdef DEBUG_AUTHLOGIN
            debug("Olympus Core >>  authLogin >> cleaning up");
        #endif

        delete tempCrypted;
        delete tempHexed;
        delete authCrypt;

        // initialize the client wide crypto
        clientCipher = new TripleDES((unsigned char *) password->data(),(int) password->length(),(unsigned char *) password->data(), (int) password->length());
    }
    else	
    {
        #ifdef DEBUG_AUTHLOGIN
            debug("Olympus Core >>  authLogin >> login ** UNSUCCESSFUL **");
        #endif
        delete username;		
        delete password;
        username = NULL;
        password = NULL;
    }

    delete prevCrypt;
    delete crypto;
    delete authfile;
    delete hexer;

    #ifdef DEBUG_AUTHLOGIN
        debug("Olympus Core >>  authLogin >>  finished login authorization");
        debug("");
    #endif

}
